
// editor colors
var c2d_colors_bg1 = "#111111";
var c2d_colors_bg2 = "#222222";
var c2d_colors_bg_block = "#111111";
var c2d_colors_bg_red = "#AA3333";
var c2d_colors_border1 = "#333333";
var c2d_colors_border2 = "#777777";
var c2d_colors_border3 = "#AAAAAA";
var c2d_colors_font1 = "#FFFFFF";
var c2d_colors_font2 = "#FFEEDD";
var c2d_colors_selected = "#9C6700";
var c2d_colors_selected_light = "#D08900";
var c2d_colors_unselected = "#1A1A1A";
var c2d_colors_opacity_disabled = 0.1;
var c2d_colors_opacity_disabled2 = 0.3;

var c2d_font = "c2d_font_regular";
var c2d_font_bold = "c2d_font_bold";
var c2d_font_size_normal = "14px";
var c2d_font_size_small = "10px";
var c2d_font_size_big = "17px";
var c2d_box_shadow = "1px  1px  5px  rgba(0,0,0,1)";
var c2d_button_focused_bg = "-webkit-gradient(linear, left top, left bottom, from(#e89900), to(#5e3e00))";
var c2d_button_blured_bg = "-webkit-gradient(linear, left top, left bottom, from(#333333), to(#222222))";
var c2d_label_bg_grad = "-webkit-gradient(linear, left top, left bottom, from(#1B343B), to(#0e1b1f))";
var c2d_label_bg_grad2 = "-webkit-gradient(linear, left top, left bottom, from(#274a54), to(#0e1b1f))";
var c2d_block_bg_grad = "-webkit-gradient(linear, left top, left bottom, from(#222222), to(#111111))";

document.body.style.fontFamily = c2d_font;
document.body.style.fontSize = c2d_font_size_normal;
document.body.style.backgroundColor = c2d_colors_bg1;

var edit_window_hidden_now = true; // when window is hidden we shouldn't add lua scripts to update controls

var Yes = true;
var No = false;

// controls
var blocks = new Array();
var blocks_cnt = 0;

var divs = new Array();
var divs_cnt = 0;

var sliders = new Array();
var sliders_cnt = 0;

var labels = new Array();
var labels_cnt = 0;

var checkboxes = new Array();
var checkboxes_cnt = 0;

var radios = new Array();
var radios_cnt = 0;

var buttons = new Array();
var buttons_cnt = 0;

var numbers = new Array();
var numbers_cnt = 0;

var stringboxes = new Array();
var stringboxes_cnt = 0;

var colors = new Array();
var colors_cnt = 0;

var textboxes = new Array();
var textboxes_cnt = 0;

var textures = new Array();
var textures_cnt = 0;
var texture_max_size_engine = 2048; // this must be the same number as Picture.cpp -> C2D_MAX_PICTURE_PIXEL_SIZE

var luaboxes = new Array();
var luaboxes_cnt = 0;

var listboxes = new Array();
var listboxes_cnt = 0;

var tables = new Array();
var tables_cnt = 0;

var grids = new Array();
var grids_cnt = 0;

var textures_root_directory = "..\\Textures\\";

var dragging_item_type = "";
var dragging_item_value = "";

var this_window_is_external = false;

// this should prevent from selecting the HTML elements with mouse
// but it disables selecting on number and listbox :-|
//window.onmousedown = function () { return false; }

// selecting control for edy builder
var control_id_selected_for_edy_builder = "";
var control_id_do_selected = false;

// These count mouse clicks as a way to know the state of mouse buttons at any time: http://stackoverflow.com/questions/322378/javascript-check-if-mouse-button-down
var any_mouse_is_down = 0;
var left_mouse_is_down = 0;
var middle_mouse_is_down = 0;
var right_mouse_is_down = 0;
// This keps track if we are checking/enabling fields when dragging across many cells in a table, or if we are disabling, based on the initial click
var checking_dragging = true;
var control_key_is_down = false;
var shift_key_is_down = false;

var hintboxobj; // object for hintbox
function select_control_for_edy_builder(event)
{
    var obj;
    if (event.srcElement)
        obj = event.srcElement; 
    else if (event.target)
        obj = event.target;
    if(obj) {
        if (obj.id_main_ctrl)
            control_id_selected_for_edy_builder = obj.id_main_ctrl;
        else control_id_selected_for_edy_builder = obj.id;
    }

    if(control_id_do_selected)
    {
         if(control_id_selected_for_edy_builder != "")
             add_lua_script("c2d:GetEdyBuilder():SelectControlByID('"+control_id_selected_for_edy_builder+"');");
    }
}

document.onmouseover = function(event)
{
    select_control_for_edy_builder(event);
}

document.body.onselectstart = function() {return false;}
document.onselectstart = function () { return false; }

document.body.onmousedown = function(event)
{
    any_mouse_is_down++;
    if (event.button == 0)
        left_mouse_is_down++;
    if (event.button == 1)
        middle_mouse_is_down++;
    if (event.button == 2)
        right_mouse_is_down++;
//    return false;
}
document.body.onmouseup = function(event)
{
    // old internal drag and drop
    //if(dragging_item_type!="")
    //{
    //    add_lua_script("c2d:StopDragItem('"+escape(dragging_item_type)+"')");
    //    dragging_item_type = "";
    //}
    
    if (--any_mouse_is_down < 0)
    {
        any_mouse_is_down = 0;
        left_mouse_is_down = 0;
        middle_mouse_is_down = 0;
        right_mouse_is_down = 0;
    }

    if (event.button == 0 && --left_mouse_is_down < 0)
        left_mouse_is_down = 0;
    if (event.button == 1 && --middle_mouse_is_down < 0)
        middle_mouse_is_down = 0;
    if (event.button == 2 && --right_mouse_is_down < 0)
        right_mouse_is_down = 0;
}
document.onkeydown = function(event)
{
    var key_code = (event.which) ? event.which : event.keyCode;
    if((key_code == 162) || (key_code == 163) || (key_code == 17) /*in external window the ctrl is 17*/) 
    {
        control_key_is_down = true;
        control_id_do_selected = true;
         if(control_id_selected_for_edy_builder != "")
             add_lua_script("c2d:GetEdyBuilder():SelectControlByID('"+control_id_selected_for_edy_builder+"');");
    }
    if ((key_code == 160) || (key_code == 161) || (key_code == 16) /*in external window the shift is 16*/)
    {
        shift_key_is_down = true;
    }

    if (enable_recording_macro_script)
    {
        // start / stop recording macro script
        if (control_key_is_down && shift_key_is_down && (key_code == 81)) {
            switch_recording_macro_script();
        }

        // run recorded macro script
        if (control_key_is_down && !shift_key_is_down && (key_code == 81)) {
            add_lua_script(macro_script);
        }
    }

}

document.onkeyup = function(event)
{
    var key_code = (event.which) ? event.which : event.keyCode;
    if((key_code == 162) || (key_code == 163) || (key_code == 17) /*in external window the ctrl is 17*/) 
    {
        control_key_is_down = false;
        control_id_do_selected = false;
    }
    if ((key_code == 160) || (key_code == 161) || (key_code == 16) /*in external window the shift is 16*/) {
        shift_key_is_down = false;
    }
}

function set_this_window_is_external() {
    this_window_is_external = true;
}

function get_this_window_is_external() {
    return this_window_is_external;
}


function c2d_drag_drop_init()
{
    c2d_drag_rec_screen = document.createElement("div");
    c2d_drag_rec_screen.setAttribute("id", "c2d_drag_rec_screen");
    c2d_drag_rec_screen.style.position = "fixed";
    c2d_drag_rec_screen.style.left = 0;
    c2d_drag_rec_screen.style.top = 0;
    c2d_drag_rec_screen.style.backgroundColor = "white";
    c2d_drag_rec_screen.style.zIndex = "101";
    c2d_drag_rec_screen.tabIndex = -1;
    c2d_drag_rec_screen.style.visibility = "hidden";
    document.body.appendChild(c2d_drag_rec_screen);

    c2d_drag_rec = document.createElement("div");
    c2d_drag_rec.setAttribute("id", "c2d_drag_rec");
    c2d_drag_rec.style.position = "fixed";
    c2d_drag_rec.style.left = 0;
    c2d_drag_rec.style.top = 0;
    c2d_drag_rec.style.backgroundColor = 'rgba(255,128,0,0.5)';
    c2d_drag_rec.style.border = "6px solid orange";
    c2d_drag_rec.style.zIndex = "101";
    c2d_drag_rec.style.padding = 0;
    c2d_drag_rec.tabIndex = -1;
    c2d_drag_rec.style.visibility = "hidden";
    document.body.appendChild(c2d_drag_rec);

    c2d_drag_hint = document.createElement("div");
    c2d_drag_hint.setAttribute("id", "c2d_drag_hint");
    c2d_drag_hint.style.position = "fixed";
    c2d_drag_hint.style.left = 0;
    c2d_drag_hint.style.top = 0;
    c2d_drag_hint.innerHTML = "drag type here"
    c2d_drag_hint.style.fontFamily = c2d_font;
    c2d_drag_hint.style.fontStyle = "normal";
    c2d_drag_hint.style.fontSize = c2d_font_size_normal;
    c2d_drag_hint.style.color = "black";
    c2d_drag_hint.style.backgroundColor = "orange";
    c2d_drag_hint.style.zIndex = "101";
    c2d_drag_hint.tabIndex = -1;
    c2d_drag_hint.style.visibility = "hidden";
    c2d_drag_hint.style.paddingLeft = 5;
    c2d_drag_hint.style.paddingRight = 5;
    document.body.appendChild(c2d_drag_hint);

    c2d_drag_drop_blink_alpha = 0.3;
    c2d_drag_drop_blink_rec_alpha = 0.5;
    c2d_drag_drop_last_block = -1;

}

c2d_drag_drop_init()

function c2d_drag_drop_blink_timer_event() {
    c2d_drag_drop_blink_alpha -= 0.1;
    c2d_drag_rec_screen.style.opacity = c2d_drag_drop_blink_alpha;
    if (c2d_drag_drop_blink_alpha > 0)
        c2d_drag_drop_blink_timer = setTimeout("c2d_drag_drop_blink_timer_event()", 50);
    else {
        c2d_drag_rec_screen.style.visibility = "hidden";
    }
}

function c2d_drag_drop_blink_rec_timer_event() {
    c2d_drag_drop_blink_rec_alpha -= 0.1;
    if (c2d_drag_drop_blink_rec_alpha < 0) c2d_drag_drop_blink_rec_alpha = 0;
    c2d_drag_rec.style.backgroundColor = "rgba(255,128,0,"+c2d_drag_drop_blink_rec_alpha+")";
    if (c2d_drag_drop_blink_rec_alpha > 0)
        c2d_drag_drop_blink_rec_timer = setTimeout("c2d_drag_drop_blink_rec_timer_event()", 50);
    else
        c2d_drag_drop_blink_rec_alpha = 0;
}

function c2d_drag_show_targets(drop_type)
{
    for(var i = 0; i < blocks_cnt; i++) {
        var block = blocks[i];
        if (block.dropfile_type != drop_type) continue;

        var bl = document.getElementById(block.block_id);
        if (bl)
            if (bl.style.display == "none") continue;

        if (blocks[i].drag_rec == undefined) {
            blocks[i].drag_rec = document.createElement("div");
        }

        var rec = bl.getBoundingClientRect();

        var drag_rec = blocks[i].drag_rec;
        drag_rec.setAttribute("id", "block_target_rec" + i);
        drag_rec.style.display = "inline";
        drag_rec.style.position = "fixed";
        drag_rec.style.left = rec.left;
        drag_rec.style.top = rec.top;
        drag_rec.style.width = rec.right - rec.left - 12;
        drag_rec.style.height = rec.bottom - rec.top - 12;
        drag_rec.style.backgroundColor = 'rgba(255,128,0,0.1)';
        drag_rec.style.border = "4px solid #DD7700";
        drag_rec.style.zIndex = "100";
        drag_rec.style.padding = 0;
        drag_rec.tabIndex = -1;
        document.body.appendChild(drag_rec);

    }
    for(var i = 0; i < divs_cnt; i++) {
        var div = divs[i];
        if (div.dropfile_type != drop_type) continue;

        var bl = document.getElementById(div.obj_id);
        if (bl)
            if (bl.style.display == "none") continue;

        if (divs[i].drag_rec == undefined) {
            divs[i].drag_rec = document.createElement("div");
        }

        var rec = bl.getBoundingClientRect();

        var drag_rec = divs[i].drag_rec;
        drag_rec.setAttribute("id", "div_target_rec" + i);
        drag_rec.style.display = "inline";
        drag_rec.style.position = "fixed";
        drag_rec.style.left = rec.left;
        drag_rec.style.top = rec.top;
        drag_rec.style.width = rec.right - rec.left - 12;
        drag_rec.style.height = rec.bottom - rec.top - 12;
        drag_rec.style.backgroundColor = 'rgba(255,128,0,0.1)';
        drag_rec.style.border = "4px solid #DD7700";
        drag_rec.style.zIndex = "100";
        drag_rec.style.padding = 0;
        drag_rec.tabIndex = -1;
        document.body.appendChild(drag_rec);

    }
}

function c2d_drag_hide_targets()
{
    for(var i = 0; i < blocks_cnt; i++) {
        if (blocks[i].drag_rec) {
            blocks[i].drag_rec.style.display = "none";
        }
    }
    for(var i = 0; i < divs_cnt; i++) {
        if (divs[i].drag_rec) {
            divs[i].drag_rec.style.display = "none";
        }
    }
}

function c2d_on_drag_enter(drop_type)
{

    c2d_drag_drop_blink_alpha = 0.3;
    c2d_drag_drop_blink_rec_alpha = 0.5;

    c2d_drag_rec_screen.style.opacity = c2d_drag_drop_blink_alpha;
    c2d_drag_rec_screen.style.visibility = "visible";
    c2d_drag_rec_screen.style.width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    c2d_drag_rec_screen.style.height = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;

    //c2d_drag_show_targets(drop_type);

    c2d_drag_drop_blink_timer = setTimeout("c2d_drag_drop_blink_timer_event()", 50);

}

function c2d_on_drag_leave()
{
    c2d_drag_hint.style.visibility = "hidden";
    c2d_drag_rec_screen.style.visibility = "hidden";
    c2d_drag_rec.style.visibility = "hidden";
    //c2d_drag_hide_targets();
}

function c2d_on_drag_drop(px, py, drop_type)
{
    for(var i = 0; i < blocks_cnt; i++) {
        var block = blocks[i];
        if (block.dropfile_type != drop_type) continue;

        var bl = document.getElementById(block.block_id);
        if (bl.style.display == "none") continue;

        var rec = bl.getBoundingClientRect();
        if ((px > rec.left) && (px < rec.right) && (py > rec.top) && (py < rec.bottom)) {
            if (blocks[i].dropfile_script != "")
                add_lua_script(blocks[i].dropfile_script);
            break;
        }
    }
    for(var i = 0; i < divs_cnt; i++) {
        var div = divs[i];
        if (div.dropfile_type != drop_type) continue;

        var bl = document.getElementById(div.obj_id);
        if (bl.style.display == "none") continue;

        var rec = bl.getBoundingClientRect();
        if ((px > rec.left) && (px < rec.right) && (py > rec.top) && (py < rec.bottom)) {
            if (divs[i].dropfile_script != "")
                add_lua_script(divs[i].dropfile_script);
            break;
        }
    }
    c2d_on_drag_leave();
}

function c2d_on_drag_over(px,py, drop_type)
{
    if (get_this_window_is_external()) {
        c2d_drag_hint.style.visibility = "visible";
        c2d_drag_hint.style.left = px + 30;
        c2d_drag_hint.style.top = py;
    }
    if (drop_type == undefined)
        return;
    if (drop_type == "")
        return;

    var found = -1;
    var drop_label = "";
    for(var i = 0; i < blocks_cnt; i++)
    {
        var block = blocks[i];
        if (block.dropfile_type != drop_type) continue;

        var bl = document.getElementById(block.block_id);
        if (bl.style.display == "none") continue;

        var rec = bl.getBoundingClientRect();
        if ((px > rec.left) && (px < rec.right) && (py > rec.top) && (py < rec.bottom))
        {
            c2d_drag_rec.style.left = rec.left;
            c2d_drag_rec.style.top = rec.top;
            c2d_drag_rec.style.width = rec.right - rec.left - 12;
            c2d_drag_rec.style.height = rec.bottom - rec.top - 12;
            c2d_drag_rec.style.visibility = "visible";
            drop_label = blocks[i].dropfile_label;
            found = i;
            break;
        }
    }

    if(found>=0)
    {
        if (c2d_drag_drop_last_block != found)
            c2d_drag_drop_blink_rec_alpha = 0.5;
        c2d_drag_hint.innerHTML = drop_label;
        if (c2d_drag_drop_blink_rec_alpha>0)
            c2d_drag_drop_blink_rec_timer = setTimeout("c2d_drag_drop_blink_rec_timer_event()", 50);
        c2d_drag_drop_last_block = found;
    }
    else
    {
        for(var i = 0; i < divs_cnt; i++) {
            var div = divs[i];
            if (div.dropfile_type != drop_type) continue;

            var bl = document.getElementById(div.obj_id);
            if (bl.style.display == "none") continue;

            var rec = bl.getBoundingClientRect();
            if ((px > rec.left) && (px < rec.right) && (py > rec.top) && (py < rec.bottom)) {
                c2d_drag_rec.style.left = rec.left;
                c2d_drag_rec.style.top = rec.top;
                c2d_drag_rec.style.width = rec.right - rec.left - 12;
                c2d_drag_rec.style.height = rec.bottom - rec.top - 12;
                c2d_drag_rec.style.visibility = "visible";
                drop_label = divs[i].dropfile_label;
                found = i;
                break;
            }
        }
        if (found >= 0) {
            if (c2d_drag_drop_last_block != found)
                c2d_drag_drop_blink_rec_alpha = 0.5;
            c2d_drag_hint.innerHTML = drop_label;
            if (c2d_drag_drop_blink_rec_alpha > 0)
                c2d_drag_drop_blink_rec_timer = setTimeout("c2d_drag_drop_blink_rec_timer_event()", 50);
            c2d_drag_drop_last_block = found;
        }
        else {
            c2d_drag_drop_blink_rec_alpha = 0.5;
            if (drop_type == "None")
                c2d_drag_hint.innerHTML = "UNSUPPORTED FILE TYPE"
            else
                c2d_drag_hint.innerHTML = drop_type + "<br>NO TARGET HERE (file(s) will be put in library)";
            c2d_drag_rec.style.visibility = "hidden";
            c2d_drag_drop_last_block = -1;
        }
    }
}

function extract_filename(full_path)
{
    return full_path.replace(/^.*(\\|\/|\:)/, '');
}

// reload edit page
function reload_edy_page(create_script)
{
    var mdiv = document.getElementById("mdiv");
    if(!mdiv) return;
    while(mdiv.childNodes.length>0) mdiv.removeChild(mdiv.childNodes[0]);
    
    control_id_selected_for_edy_builder = "";
    hidehintbox();
    
    blocks = new Array();
    blocks_cnt = 0;
    divs = new Array();
    divs_cnt = 0;
    sliders = new Array();
    sliders_cnt = 0;
    labels = new Array();
    labels_cnt = 0;
    checkboxes = new Array();
    checkboxes_cnt = 0;
    radios = new Array();
    radios_cnt = 0;
    buttons = new Array();
    buttons_cnt = 0;
    numbers = new Array();
    numbers_cnt = 0;
    stringboxes = new Array();
    stringboxes_cnt = 0;
    colors = new Array();
    colors_cnt = 0;
    textboxes = new Array();
    textboxes_cnt = 0;
    textures = new Array();
    textures_cnt = 0;
    luaboxes = new Array();
    luaboxes_cnt = 0;
    listboxes = new Array();
    listboxes_cnt = 0;
    tables = new Array();
    tables_cnt = 0;
    grids = new Array();
    grids_cnt = 0;
    //mdiv.innerHTML = create_script.length;
    for(var i=0; i<create_script.length; i++) eval(unescape(create_script[i]));
}

var edy_control_selected_now = false;
var edy_select_rect = false;
function edy_select_control(name)
{
    restore_all_blocks("");

    if(!edy_select_rect)
    {
        edy_select_rect = document.createElement("div");
        edy_select_rect.setAttribute("id", "edy_select_rect");
        edy_select_rect.style.position = "absolute";
        edy_select_rect.style.width = 10;
        edy_select_rect.style.height = 10;
        edy_select_rect.style.backgroundColor = "rgba(255,255,200,0.3)";
        edy_select_rect.style.padding = "0px";
        edy_select_rect.style.border = "10px solid rgba(255,255,200,0.6)";
        edy_select_rect.style.borderRadius = "10px";
        edy_select_rect.style.fontFamily = c2d_font;
        edy_select_rect.style.fontStyle = "normal";
        edy_select_rect.style.fontSize = c2d_font_size_normal;
        edy_select_rect.style.zIndex = "100";
        edy_select_rect.onmousedown = function () { return false; }
        document.body.appendChild(edy_select_rect);
    }
    edy_select_rect.style.visibility = "hidden";




    if (edy_control_selected_now)
        if (typeof edy_control_selected_now.onmouseout == 'function')
            edy_control_selected_now.onmouseout();

    hidehintbox();

    edy_control_selected_now = document.getElementById(name);
    if (edy_control_selected_now) {

        if (typeof edy_control_selected_now.onmouseover == 'function')
            edy_control_selected_now.onmouseover();

        var rec = edy_control_selected_now.getBoundingClientRect();
        edy_select_rect.style.left = rec.left -15;
        edy_select_rect.style.top = rec.top + document.body.scrollTop -15;
        edy_select_rect.style.width = rec.right - rec.left +10;
        edy_select_rect.style.height = rec.bottom - rec.top +10;
        edy_select_rect.style.visibility = "visible";


        scroll_to_block(edy_control_selected_now, -200);

    }

}

function str_true_false(val)
{
    if(val==undefined) return "false";
    if(val==true) return "true";
    if(val=="true") return "true";
    return "false";
}

// mouse events

var number_wheeling_obj;
var number_wheeling_obj_started = false;
var number_wheeling_obj_lastX = 0;
var number_wheeling_obj_lastY = 0;
var number_wheeling_obj_undo_serie_started = false;

function start_num_wheel(on_obj) 
{
    number_wheeling_obj = on_obj;
    number_wheeling_obj_started = false;
    number_wheeling_obj_undo_serie_started = false;
}

document.onmousemove = function(event)
{
    if(number_wheeling_obj) 
    {
        if(!number_wheeling_obj_started)
        {
            number_wheeling_obj_started = true;
            number_wheeling_obj_lastX = event.clientX;
            number_wheeling_obj_lastY = event.clientY;
        }
        else
        {
            if(!number_wheeling_obj_undo_serie_started)
            {
                number_wheeling_obj.wheel_undo_serie_start();
                number_wheeling_obj_undo_serie_started = true;
            }
            var steps = number_wheeling_obj_lastY-event.clientY + event.clientX - number_wheeling_obj_lastX;
            number_wheeling_obj.wheel_update_value(steps);
            number_wheeling_obj_lastX = event.clientX;
            number_wheeling_obj_lastY = event.clientY;
        }
    }
}

document.onmouseup = function(event)
{
    if((number_wheeling_obj) && (number_wheeling_obj_undo_serie_started))
    {
        number_wheeling_obj.wheel_undo_serie_end();
    }
    number_wheeling_obj = null;
    number_wheeling_obj_lastY = -1;
    number_wheeling_obj_started = false;
    number_wheeling_obj_undo_serie_started = false;
}

// get element position function
function get_element_position(obj) 
{
    var obj_y = 0;
    var obj_x = 0;
    var obj2 = obj;
    if (document.getElementById || document.all) 
    {
        do  
        {
            obj_x += (obj.offsetLeft-obj.scrollLeft);
            obj_y += (obj.offsetTop-obj.scrollTop);
            obj = obj.offsetParent;
            obj2 = obj2.parentNode;
            while (obj2!=obj) 
            {
                obj_x -= obj2.scrollLeft;
                obj_y -= obj2.scrollTop;
                obj2 = obj2.parentNode;
            }
        } while (obj.offsetParent)
    } 
    else if (document.layers) 
    {
        obj_y += obj.y;
        obj_x += obj.x;
    }
    return [obj_x, obj_y];
}  

function is_my_ctrl_hidden_now(obj)
{
    if(obj.style.display == "none") return true;
    var obj2 = obj.parentNode;
    while (obj2!=document.body)
    {
        if(obj2.style.display == "none") return true;
        obj2 = obj2.parentNode;
    }
    return false;
}


// animated scroll
var animscroll_timer = 0;
var animscroll_target_y = 0;
var animscroll_steps = 0;
var anim_scroll_plus_offset_y = 70;

function scroll_to_block(obj, plus_ofs)
{
    if (plus_ofs == undefined) plus_ofs = 0;
    animscroll_target_y = get_element_position(obj)[1] - anim_scroll_plus_offset_y + plus_ofs;
    animscroll_steps = 20;
    animscroll_timer = setTimeout("animscroll_on_timer()", 30);
}

function scroll_to_element(obj)
{
    animscroll_target_y = get_element_position(obj)[1];
    animscroll_steps = 20;
    animscroll_timer = setTimeout("animscroll_on_timer()", 30);
}

function scrolling_now()
{
    return animscroll_steps > 0;
}

function animscroll_on_timer()
{
    animscroll_steps = animscroll_steps -1;
    var where_y = animscroll_target_y;
    if(animscroll_steps>0) 
    {
        where_y = window.pageYOffset;
        var shift = (animscroll_target_y-where_y);
        if(shift>0) shift = shift + 4;
        if(shift<0) shift = shift - 4;
        if((shift>2) || (shift<-2)) shift = shift*0.3;
        where_y = where_y + shift;
    }
    window.scrollTo(0, where_y);
    
    if(animscroll_steps>0)
        animscroll_timer = setTimeout("animscroll_on_timer()", 30);
}

// HINTBOX

// hintbox occupies two events of hinted object: onMouseOver and onMouseOut

var hintbox_timer = 0;
var hintbox_text = "";
var hintbox_for_obj;
var hintbox_width = "";
var hintbox_time_to_show = 500;
var hintbox_pos_down = true; // when true, then showing hinbox under the control, otherwise showing right to the control

function showhintbox(hint_text, hint_for_obj, hint_width, assign_onmouseout)
{
    hintbox_text = hint_text;
    hintbox_for_obj = hint_for_obj;
    hintbox_width = hintbox_width;
    if (assign_onmouseout) {
        hintbox_for_obj.onmouseout = hidehintbox;
    }
    clearTimeout(hintbox_timer);
    hintbox_timer = setTimeout("showhintbox_on_timer()", hintbox_time_to_show);
}

function showhintbox_imm(hint_text, hint_for_obj, hint_width)
{
    hintbox_text = hint_text;
    hintbox_for_obj = hint_for_obj;
    hintbox_width = hintbox_width;
    hintbox_for_obj.onmouseout = hidehintbox;
    clearTimeout(hintbox_timer);
    hintbox_timer = setTimeout("showhintbox_on_timer()", 1);
}

function fix_hintbox_position()
{
    var obj_pos = get_element_position(hintbox_for_obj);

    // calculate hint position and shift it if out of scroll area

    var cx,cy,cw,ch;
    cx =  document.body.scrollLeft;
    cy =  document.body.scrollTop;
    cw =  document.body.clientWidth;
    ch =  document.body.clientHeight;
    
    var hx, hy;
    if (hintbox_pos_down) {
        hx = obj_pos[0] + 5;
        hy = obj_pos[1] + hintbox_for_obj.offsetHeight + 2;
    } else {
        hx = obj_pos[0] + hintbox_for_obj.offsetWidth;
        hy = obj_pos[1];
    }
    
    if(hx+hintboxobj.offsetWidth>(cx+cw) ) hx = (cx+cw) - hintboxobj.offsetWidth;
    if(hx < cx) hx = cx;
    if(hy+hintboxobj.offsetHeight>(cy+ch) ) hy = (cy+ch) - hintboxobj.offsetHeight;
    if(hy < cy) hy = cy;
    
    hx -= cx;
    hy -= cy; // hintbox style position is "fixed", so we adjust position by scroll


    hintboxobj.style.left = hx + "px";
    hintboxobj.style.top = hy + "px";
}

function showhintbox_on_timer()
{

    hintboxobj=document.getElementById("hintbox");
    hintboxobj.innerHTML=hintbox_text;
//     hintboxobj.style.left=hintboxobj.style.top=-1000;
//     if (hintbox_width!="") hintboxobj.style.width=hintbox_width;
//     else hintboxobj.style.width="200px";

    hintboxobj.style.width="";
    hintboxobj.style.height="";

    //if(hintboxobj.clientWidth>200) hintboxobj.style.width="200px";


    
    // show the hintbox window now
    hintboxobj.style.visibility="visible";

    fix_hintbox_position();

    //hintbox_for_obj.onmouseout=hidehintbox;
}



function hidehintbox()
{
    if(hintbox_for_obj != undefined)
        if(hintbox_for_obj.onmouseout2 != undefined) hintbox_for_obj.onmouseout2();
    clearTimeout(hintbox_timer);
    hintboxobj = document.getElementById("hintbox");
    if (hintboxobj != undefined) {
        hintboxobj.style.visibility = "hidden";
        hintboxobj.style.left = "-1000px";
    }
}

function create_hintbox()
{
    hintboxobj = document.createElement("div");
    hintboxobj.setAttribute("id", "hintbox");
    hintboxobj.style.position = "fixed";
    hintboxobj.style.backgroundColor = "lightyellow";
    hintboxobj.style.padding = "4px";
    hintboxobj.style.border = "1px solid black";
    hintboxobj.style.fontFamily = c2d_font;
    hintboxobj.style.fontStyle = "normal";
    hintboxobj.style.fontSize = c2d_font_size_normal;
    hintboxobj.style.zIndex = "101";
    hintboxobj.style.visibility="hidden";
    hintboxobj.style.borderRight = "2px solid black";
    hintboxobj.style.borderBottom = "2px solid black";
    hintboxobj.onmousedown = function() { return false; }
    document.body.appendChild(hintboxobj);
}

function c2d_editor_init()
{
    create_hintbox();
}

function create_macro_record_buttons()
{
    var btn_tab = document.getElementById("space_for_macro_recording_button1");
    if (btn_tab)
    {
        var jsc = "switch_recording_macro_script();";
        var hint = "<img src='icon_record_mini.png'> <b> record macro</b><br><br>click to start recording a macro, then make changes to object's parameters in this edit page, then click here again (or press ctrl+shift+Q) to stop recording, then you can use this macro to apply the same changes to different object by clicking the other button or pressing ctrl+Q in this window.<br><br>macro is recorded only inside this one edit page. each edit page has its own macro for recording and running. if you switch to different edit page while recording the macro then changes are not recorded to this macro.<br><br>macro records lua scripts that are run by the editor when changing values with mouse or keyboard."
        add_button("record_macro_btn", "", 20, 20, "", "", hint, "space_for_macro_recording_button1", No, "", jsc, "icon_record_mini.png", 0);

        jsc = "add_lua_script(macro_script);";
        hint = "<img src='icon_play_record_mini.png'> <b> run macro</b><br><br>click to run recorded macro. key shortcut to run macro is ctrl+Q, while this window must be focused."
        add_button("play_record_macro_btn", "", 20, 20, "", "", hint, "space_for_macro_recording_button2", No, "", jsc, "icon_play_record_mini.png", 0);

        var btn_rec = document.getElementById("record_macro_btn");
        btn_rec.style.margin = "0px";
        btn_rec.style.padding = "0px";
        btn_rec.style.marginTop = "3px";
        btn_rec.button_icon.style.margin = "0px";
        btn_rec.button_icon.style.padding = "0px";

        var btn_play = document.getElementById("play_record_macro_btn");
        btn_play.style.margin = "0px";
        btn_play.style.marginTop = "3px";
        btn_play.style.padding = "0px";
        btn_play.button_icon.style.margin = "0px";
        btn_play.button_icon.style.padding = "0px";
    }

}

function make_main_buttons_header(select_which, header_caption)
{
    create_main_buttons_header(select_which, header_caption);
    create_macro_record_buttons();
}

// JAVA EVALUATE FUNCTION

function my_eval(eval_str)
{
    // java script evaluations can be checked here
    eval(eval_str);
}

// LUA SCRIPT handling

var lua_script_string = "";

var enable_recording_macro_script = true;
var recording_macro_script = false;
var macro_script = "";

function add_lua_script(lua_script_str)
{
    // one complete lua script can be added, so we check if it ends with semicolon
    if(lua_script_str==undefined) return;
    if(lua_script_str=="") return;
    if(lua_script_str.charAt(lua_script_str.length-1)!=';') lua_script_str = lua_script_str + ';';
    lua_script_string = lua_script_string + lua_script_str;

    if (recording_macro_script)
        macro_script = macro_script + lua_script_str;
}

function add_lua_script_if_not_added_already(lua_script_str)
{
    // one complete lua script can be added, so we check if it ends with semicolon
    if(lua_script_str==undefined) return;
    if(lua_script_str=="") return;
    if(lua_script_str.charAt(lua_script_str.length-1)!=';') lua_script_str = lua_script_str + ';';
    if (lua_script_string.indexOf(lua_script_str) == -1) {
        lua_script_string = lua_script_string + lua_script_str;
        if (recording_macro_script)
            macro_script = macro_script + lua_script_str;
    }
}

function get_lua_script()
{
    // application calls this function to get all lua scripts we want to run from editor
    if(lua_script_string == undefined) return "";
    var my_ret = lua_script_string;
    lua_script_string = "";
    return my_ret;
}

function recording_blink() {
    var btn = document.getElementById('recording_macro_hint_btn')
    if (btn) {
        if (btn.blink_col == 1)
            btn.style.borderColor = "#FFFFFF";
        else
            btn.style.borderColor = c2d_colors_bg_red;

        btn.blink_col = -btn.blink_col;

        btn.blink_timer = setTimeout("recording_blink()", 500);
    }
}

function start_recording_macro_script()
{
    if (recording_macro_script)
        return

    recording_macro_script = true
    macro_script = ""

    var btn = document.createElement('button')

    btn.id = 'recording_macro_hint_btn'
    btn.style.position = 'fixed'
    btn.style.left = 0
    btn.style.top = 0
    btn.style.width = '100%'
    btn.style.height = 66
    btn.style.zIndex = 101
    btn.style.color = c2d_colors_bg1;

    var btn_icon = document.createElement("img")
    btn_icon.src = "icon_record.png"
    btn_icon.style.verticalAlign = "middle"
    btn.appendChild(btn_icon)
    btn_icon.onmousedown = function () { return true; }
    btn.btn_icon = btn_icon;
    btn.style.backgroundColor = "#444444";
    btn.style.color = c2d_colors_font1;
    btn.style.borderColor = c2d_colors_bg_red;
    btn.style.borderWidth = 1

    btn.blink_col = 1;
    btn.blink_timer = setTimeout("recording_blink()", 500);

    btn.appendChild(document.createTextNode('recording macro. press ctrl+shift+Q (or click here) to stop recording, then ctrl+Q to run recorded macro'))
    document.body.appendChild(btn)

    btn.onmouseup = function () {
        stop_recording_macro_script();
    }

}

function stop_recording_macro_script()
{
    if (!recording_macro_script)
        return;
    recording_macro_script = false;

    var btn = document.getElementById('recording_macro_hint_btn')
    if (btn) {
        document.body.removeChild(btn)
    }

}

function switch_recording_macro_script()
{
    if (recording_macro_script)
        stop_recording_macro_script()
    else
        start_recording_macro_script();
}


// LUA SCRIPT for updating controls

var lua_script_update_string = "";
var request_update_all_done_once = false; // we remember this so we don't call request update controls more times in one frame, just once

function add_lua_script_update(lua_script_str)
{
    // one complete lua script can be added, so we check if it ends with semicolon
    if(lua_script_str==undefined) return;
    if(lua_script_str=="") return;
    if(lua_script_str.charAt(lua_script_str.length-1)!=';') lua_script_str = lua_script_str + ';';
    lua_script_update_string = lua_script_update_string + lua_script_str;
}

function add_lua_script_update_if_not_added_already(lua_script_str)
{
    // one complete lua script can be added, so we check if it ends with semicolon
    if(lua_script_str==undefined) return;
    if(lua_script_str=="") return;
    if(lua_script_str.charAt(lua_script_str.length-1)!=';') lua_script_str = lua_script_str + ';';
    if(lua_script_update_string.indexOf(lua_script_str) == -1)
        lua_script_update_string = lua_script_update_string + lua_script_str;
}

function get_lua_script_update()
{
    // application calls this function to get all lua scripts we want to run from editor
    if(lua_script_update_string == undefined) return "";
    var my_ret = lua_script_update_string;
    lua_script_update_string = "";
    request_update_all_done_once = false; // we send lua script to update controls, so we can collect next ones
    return my_ret;
}

// request update all controls
function request_update_all_controls()
{
    if(edit_window_hidden_now) return;
    if(request_update_all_done_once) return;
    
    add_lua_script_update("c2d:EdyUpdateDropTargetsClear();");

    for(var i = 0; i < blocks_cnt; i++) request_update_block(i);
    for(var i = 0; i < divs_cnt; i++) request_update_div(i);
    for(var i = 0; i < labels_cnt; i++) request_update_label(i);
    for(var i = 0; i < sliders_cnt; i++) request_update_slider(i);
    for(var i = 0; i < checkboxes_cnt; i++) request_update_checkbox(i);
    for(var i = 0; i < buttons_cnt; i++) request_update_button(i);
    for(var i = 0; i < radios_cnt; i++) request_update_radio(i);
    for(var i = 0; i < numbers_cnt; i++) request_update_number(i);
    for(var i = 0; i < stringboxes_cnt; i++) request_update_stringbox(i);
    for(var i = 0; i < textboxes_cnt; i++) request_update_textbox(i);
    for(var i = 0; i < colors_cnt; i++) request_update_color(i);
    for(var i = 0; i < textures_cnt; i++) request_update_texture(i);
    for(var i = 0; i < luaboxes_cnt; i++) request_update_luabox(i);
    for(var i = 0; i < listboxes_cnt; i++) request_update_listbox(i);
    for(var i = 0; i < grids_cnt; i++) request_update_grid(i);

    request_update_all_done_once = true;
}

// TIMER


var main_c2d_editor_update_timer = 0;
function timer_event()
{
    if(!edit_window_hidden_now) request_update_all_controls();
    main_c2d_editor_update_timer = setTimeout("timer_event()", 200);
}

function startup_timer()
{
    main_c2d_editor_update_timer = setTimeout("timer_event()", 200);
}

function stop_timer()
{
    if(main_c2d_editor_update_timer!=0) clearTimeout(main_c2d_editor_update_timer);
    main_c2d_editor_update_timer = 0;
}

// SHOW and HIDE WINDOW EVENTS that are sent from app

function show_window_event()
{
    edit_window_hidden_now = false;
    timer_event(); // requests to update all controls and starts the timer
    hidehintbox();
    left_mouse_is_down = false;
    middle_mouse_is_down = false;
    right_mouse_is_down = false;
    control_key_is_down = false;

    if (typeof show_window_event_local === 'function') {
        show_window_event_local();
    }

}

function hide_window_event()
{
    edit_window_hidden_now = true;
    stop_timer(); // stops the timer when the window is hidden, so we don't request game to update controls
    hidehintbox();
    left_mouse_is_down = false;
    middle_mouse_is_down = false;
    right_mouse_is_down = false;
    control_key_is_down = false;
    shift_key_is_down = false;
}

function focus_window_event()
{
    edit_window_hidden_now = false;
    left_mouse_is_down = false;
    middle_mouse_is_down = false;
    right_mouse_is_down = false;
    control_key_is_down = false;
    shift_key_is_down = false;
    if (edy_select_rect)
        edy_select_rect.style.visibility = "hidden";

}

function blur_all_elements()
{
    var len = document.all.length;
    for(var i=0; i<len; i++) { document.all[i].blur(); }
}

function blur_window_event()
{
    left_mouse_is_down = false;
    middle_mouse_is_down = false;
    right_mouse_is_down = false;
    control_key_is_down = false;
    blur_all_elements();
    hidehintbox();
}


function disable_all_elements()
{
    //for(var i=0; i<labels_cnt; i++) 
    //for(var i=0; i<textures_cnt; i++) 
    for(var i=0; i<sliders_cnt; i++) document.getElementById(sliders[i].obj_id).disabled = true;
    for(var i=0; i<buttons_cnt; i++) document.getElementById(buttons[i].obj_id).disabled = true;
    for(var i=0; i<radios_cnt; i++) document.getElementById(radios[i].obj_id).disabled = true;
    for(var i=0; i<numbers_cnt; i++) document.getElementById(numbers[i].obj_id).disabled = true;
    for(var i=0; i<stringboxes_cnt; i++) document.getElementById(stringboxes[i].obj_id).disabled = true;
    for(var i=0; i<textboxes_cnt; i++) document.getElementById(textboxes[i].obj_id).disabled = true;
    for(var i=0; i<colors_cnt; i++) document.getElementById(colors[i].obj_id).disabled = true;
    for(var i=0; i<luaboxes_cnt; i++) document.getElementById(luaboxes[i].obj_id).disabled = true;
    for(var i=0; i<listboxes_cnt; i++) document.getElementById(listboxes[i].obj_id).disabled = true;
    for(var i=0; i<checkboxes_cnt; i++) document.getElementById(checkboxes[i].obj_id).disabled = true;
}

function focus_element(obj_id)
{
    document.getElementById(obj_id).focus();
}


// CONTROLS:



// NEW LINE

function add_new_line(obj_id, append_to_obj)
{
    var my_br = document.createElement("br");
    my_br.id = obj_id;
    my_br.onmousedown = function () { return false; }
    document.getElementById(append_to_obj).appendChild(my_br);
}

function add_hr_line(append_to_obj)
{
    document.getElementById(append_to_obj).appendChild(document.createElement("hr"));
}


// BLOCK

function request_update_block(wh)
{
    var block = blocks[wh];

    if (block.lua_getvisible != "")
    {
        add_lua_script_update("c2d:EdyUpdateBlockVisibility('" + block.block_id + "', " + block.lua_getvisible + ");");
    }

    if(block.dropfile_type != "")
    {
        var bl = document.getElementById(block.block_id);
        var rec = bl.getBoundingClientRect();

        add_lua_script_update("c2d:EdyUpdateDropTargetsAdd('" + block.dropfile_type + "',\
c2d:Unescape('" + escape(block.dropfile_label) + "'),\
c2d:Unescape('" + escape(block.dropfile_script) + "'),\
" + rec.left + ", " + rec.top + ", " + rec.right + ", " + rec.bottom + ");");
    }
}


function add_block(block_id, label_string, append_to_obj, block_width, block_height, valign, color_index, icon_img, forbid_minimize, forbid_autoscroll, label_color, lua_getvisible, dropfile_type, dropfile_label, dropfile_script)
{
    if (icon_img == undefined) icon_img = "";
    if (forbid_minimize == undefined) forbid_minimize = false;
    if (forbid_autoscroll == undefined) forbid_autoscroll = false;
    if (label_color == undefined) label_color = "#FFFFFF";
    if (label_color == "") label_color = "#FFFFFF";
    if (lua_getvisible == undefined) lua_getvisible = "";
    if (dropfile_type == undefined) dropfile_type = "";
    if (dropfile_label == undefined) dropfile_label = "";
    if (dropfile_script == undefined) dropfile_script = "";

    
    blocks[blocks_cnt] = new Object();
    blocks[blocks_cnt].block_id = block_id;
    blocks[blocks_cnt].lua_getvisible = lua_getvisible;
    blocks[blocks_cnt].dropfile_type = dropfile_type;
    blocks[blocks_cnt].dropfile_label = dropfile_label;
    blocks[blocks_cnt].dropfile_script = dropfile_script;
    blocks_cnt = blocks_cnt + 1;
    var block = document.createElement("table");
    block.id = block_id;

    document.getElementById(append_to_obj).appendChild(block);
    if(block_width!="") block.style.width = block_width;
    if(block_height!="") block.style.height = block_height;
    block.style.display = "inline";
    block.style.verticalAlign = "top";
    block.style.fontSize = c2d_font_size_normal;
    block.style.border = "1px solid #222222";
    block.style.padding = "2px";
    block.style.paddingLeft = "1px";
    block.style.paddingBottom = "0";
    block.style.margin = "1px";
    block.style.marginRight = "5px";
    block.style.marginTop = "6px";
    block.style.marginBottom = "6px";
    block.style.backgroundColor = c2d_colors_bg_block;
    block.my_controls_hidden = false;
    block.this_is_my_block = true;
    block.my_block_forbid_minimize = forbid_minimize;
    if(valign!="") { block.style.textAlign = valign; }
    block.my_mouse_press = false;
    block.style.borderRadius = "4px"
    block.style.boxShadow = c2d_box_shadow;
    //block.style.background = c2d_block_bg_grad;
    //block.onselectstart = "return false;"

    var label = document.createElement('div')
    block.appendChild(label);
    label.style.width = "100%";
    label.style.textAlign = "left"
    if(valign!="") { label.style.textAlign = valign; }
    if(!forbid_minimize) label.style.cursor = "pointer";
    label.style.borderBottom = "0px solid #222222";
    label.style.backgroundColor = "#1B343B";//"#222F33";//c2d_colors_bg2;
    label.style.background = c2d_label_bg_grad;
    label.style.marginBottom = "3px";
    label.style.textShadow = "0px 0px 10px black";
    label.style.borderRadius = "4px"
    label.style.boxShadow = c2d_box_shadow;

    
    label.onmousedown = function() { return false; }
    
    block.onselectstart = function() { return false; }

    //if(icon_img != "")
    {
        //label.style.textAlign = "left";
        var lab_ico = document.createElement("img");
        if (icon_img != "")
            lab_ico.src = icon_img + "?" + (new Date()).getTime();
        lab_ico.style.display = "inline-block";
        lab_ico.style.verticalAlign = "middle";
        lab_ico.style.marginLeft = "8";
        lab_ico.style.marginRight = "5";
        label.appendChild(lab_ico);
        lab_ico.id_main_ctrl = block_id;
    }

    label.style.color = label_color;
    label.style.fontWeight = "normal";
    label.style.fontFamily = c2d_font_bold;
    //label.style.textShadow="0px 0px 30px #FFFFFF";
    label.style.fontSize = c2d_font_size_big;
    label.style.paddingTop = "4px";
    label.style.paddingBottom = "4px";

    var tnode = document.createTextNode(label_string);
    label.appendChild(tnode);

    block.block_label = label;
    block.block_label.id_main_ctrl = block_id;

    if ((label_string == "") && (icon_img == "")) {
        block.block_label.style.display = "none";
        block.style.margin = "0px";
    }

    if (!forbid_minimize)
    {
        label.onmousedown = function ()
        {
            block.my_mouse_press = true;
            return false;
        }

        label.onmouseup = function () 
        {
            if(block.my_mouse_press)
            {
                block.my_mouse_press = false;
                if(block.my_controls_hidden) 
                {
                    restore_block(block_id)
                    if(!forbid_autoscroll) scroll_to_block(block);
                }
                else minimize_block(block_id)
            }
        }

        label.onmouseover = function () {
            label.style.background = c2d_button_focused_bg;
        }

        label.onmouseout = function () {
            label.style.background = c2d_label_bg_grad;
        }
    }
    

}

function minimize_block(block_id) 
{
    var block = document.getElementById(block_id);
    if(block.my_block_forbid_minimize) return;
    var c = block.childNodes;
    block.my_controls_hidden = true;
    for(var i=0; i<c.length; i++) {
        if(c[i]==block.block_label) continue;
        c[i].style.display = "none";
    }
}

function restore_block(block_id, scroll_to_it)
{
    var block = document.getElementById(block_id);
    var c = block.childNodes;
    block.my_controls_hidden = false;
    for(var i=0; i<c.length; i++) {
        if(c[i]==block.block_label) continue;
        if(c[i].my_control_leave_hidden) continue;
        if(c[i].this_is_my_block) c[i].style.display = "inline";
        else c[i].style.display = "inline";
    }
    if (scroll_to_it)
            scroll_to_block(block);
}

function minimize_all_blocks()
{
    for(var i=0; i<blocks_cnt; i++) minimize_block(blocks[i].block_id);
}

function all_blocks_are_minimized()
{
    for(var i=0; i<blocks_cnt; i++) 
    {
        var block = document.getElementById(blocks[i].block_id);
        if(block.my_block_forbid_minimize) continue;
        if(block.my_controls_hidden == false) return false;
    }
    return true;
}
function restore_all_blocks(except_of_block_id) 
{
    if (except_of_block_id == undefined)
        except_of_block_id = "";

    for (var i = 0; i < blocks_cnt; i++)
    {
        if (blocks[i].block_id == except_of_block_id)
            continue;

        restore_block(blocks[i].block_id);
    }
}


// DIV

function request_update_div(wh) {
    var div = divs[wh];

    if (div.dropfile_type != "") {
        var bl = document.getElementById(div.obj_id);
        var rec = bl.getBoundingClientRect();

        add_lua_script_update("c2d:EdyUpdateDropTargetsAdd('" + div.dropfile_type + "',\
c2d:Unescape('" + escape(div.dropfile_label) + "'),\
c2d:Unescape('" + escape(div.dropfile_script) + "'),\
" + rec.left + ", " + rec.top + ", " + rec.right + ", " + rec.bottom + ");");
    }
}


function add_div(obj_id, append_to_obj, div_width, div_height, dropfile_type, dropfile_label, dropfile_script) {
    if (div_width == undefined) div_width = "";
    if (div_height == undefined) div_height = "";
    if (dropfile_type == undefined) dropfile_type = "";
    if (dropfile_label == undefined) dropfile_label = "";
    if (dropfile_script == undefined) dropfile_script = "";


    divs[divs_cnt] = new Object();
    divs[divs_cnt].obj_id = obj_id;
    divs[divs_cnt].dropfile_type = dropfile_type;
    divs[divs_cnt].dropfile_label = dropfile_label;
    divs[divs_cnt].dropfile_script = dropfile_script;
    divs_cnt = divs_cnt + 1;
    var div = document.createElement("div");
    div.id = obj_id;

    document.getElementById(append_to_obj).appendChild(div);
    if (div_width != "") div.style.width = div_width;
    if (div_height != "") div.style.height = div_height;
    div.style.verticalAlign = "top";
    div.style.fontSize = c2d_font_size_normal;
    div.style.border = "0";
    div.style.padding = "0";
    div.style.margin = "0";
    div.my_controls_hidden = false;
    div.style.borderRadius = "4px"
    div.style.boxShadow = c2d_box_shadow;

    div.onselectstart = function () { return false; }

}


// CHECK BOX

function request_update_checkbox(wh)
{
    if (checkboxes[wh].update_script == "") return;
    if (is_my_ctrl_hidden_now(checkboxes[wh].obj)) return;

    if (checkboxes[wh].lua_enabled_script != "") {
        var lua_script = "c2d:EdyUpdateCheckboxEnabled('" + checkboxes[wh].obj_id + "', " + checkboxes[wh].lua_enabled_script + ");";
        add_lua_script_update(lua_script);
    }

    var lua_script = "c2d:EdyUpdateCheckbox('"+checkboxes[wh].obj_id+"', " + checkboxes[wh].update_script + ")"
    if (checkboxes[wh].lua_enabled_script != "") {
        lua_script = "if(" + checkboxes[wh].lua_enabled_script + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_checkbox(checkbox_id, new_value)
{
    document.getElementById(checkbox_id).checked = new_value == "true";
}

function add_checkbox(obj_id, label_string, is_checked, lua_on_check, lua_on_uncheck, update_script, hint_text, append_to_obj, end_with_new_line, lua_enabled_script)
{
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    var checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    if(obj_id!="")
    {
        checkboxes[checkboxes_cnt] = new Object();
        checkboxes[checkboxes_cnt].obj_id = obj_id;
        checkboxes[checkboxes_cnt].obj = checkbox;
        checkboxes[checkboxes_cnt].update_script = update_script;
        checkboxes[checkboxes_cnt].lua_enabled_script = lua_enabled_script;
        checkboxes_cnt = checkboxes_cnt +1;
    }
    
    checkbox.id = obj_id;
    checkbox.checked = is_checked;
    checkbox.style.boxShadow = c2d_box_shadow;

    var label = document.createElement('label')
    label.htmlFor = obj_id;
    label.style.color = c2d_colors_font1;
    label.appendChild(document.createTextNode(label_string));
    checkbox.checkbox_label = label;
    checkbox.checkbox_label.id_main_ctrl = obj_id;
    //label.onselectstart = "return false;"

    var mdivv = document.getElementById(append_to_obj);
    
//    checkbox.onmousedown = function() { return false; }
//    label.onmousedown = function() { return false; }
    
//    label.style.verticalAlign = "top";
    
    mdivv.appendChild(checkbox);
    mdivv.appendChild(label);
    
    
    checkbox.style.cursor = "pointer";
    label.style.cursor = "pointer";

    checkbox.setAttribute("onclick", "hidehintbox(); if(checked) {add_lua_script(\""+lua_on_check+"\");} else {add_lua_script(\""+lua_on_uncheck+"\");}");
    
    if(hint_text!="") 
    {
        checkbox.onmouseover = function(){showhintbox(hint_text, this, '', Yes)};
        label.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    }
    
    if(end_with_new_line) add_new_line("", append_to_obj);
}


// RADIO

function request_update_radio(wh)
{
    if (is_my_ctrl_hidden_now(radios[wh].obj)) return;

    if (radios[wh].lua_enabled_script != "") {
        var lua_script = "c2d:EdyUpdateRadioEnabled('" + radios[wh].obj_id + "', " + radios[wh].lua_enabled_script + ");";
        add_lua_script_update(lua_script);
    }

    if (radios[wh].update_script == "") return;
    var lua_script = "c2d:EdyUpdateRadio('" + radios[wh].obj_id + "', " + radios[wh].update_script + ");";
    if (radios[wh].lua_obj_check != "")
    {
        lua_script = "if(" + radios[wh].lua_obj_check + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_radio(radio_id, new_value)
{
    document.getElementById(radio_id).checked = new_value == document.getElementById(radio_id).value;
}

function add_radio(obj_id, checkbox_group, label_string, value, lua_on_click, update_script, hint_text, append_to_obj, end_with_new_line, lua_enabled_script, lua_obj_check)
{
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    if (lua_obj_check == undefined) lua_obj_check = "";

    var radio = document.createElement("input");
    radio.type = "radio";
    if(obj_id!="")
    {
        radios[radios_cnt] = new Object();
        radios[radios_cnt].obj_id = obj_id;
        radios[radios_cnt].obj = radio;
        radios[radios_cnt].update_script = update_script;
        radios[radios_cnt].lua_enabled_script = lua_enabled_script;
        radios[radios_cnt].lua_obj_check = lua_obj_check;
        radios_cnt = radios_cnt +1;
    }

    radio.id = obj_id;
    radio.name = checkbox_group;
    radio.value = value;

    var label = document.createElement('label')
    label.htmlFor = obj_id;
    label.appendChild(document.createTextNode(label_string));
    label.style.color = c2d_colors_font1;

    radio.radio_label = label;
    radio.radio_label.id_main_ctrl = obj_id;

    var mdivv = document.getElementById(append_to_obj);
    mdivv.appendChild(radio);
    mdivv.appendChild(label);
    
    radio.style.cursor = "pointer";
    label.style.cursor = "pointer";
    
    //radio.setAttribute("onclick", "hidehintbox(); my_eval(\"add_lua_script('"+lua_on_click+"');\");");
    radio.onclick = function () 
    {
        hidehintbox(); 
        add_lua_script(lua_on_click);
    }

    if(hint_text!="") 
    {
        radio.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
        label.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    }
    
    if(end_with_new_line) add_new_line("", append_to_obj);
}


// BUTTON

function request_update_button(wh)
{
    if(is_my_ctrl_hidden_now(buttons[wh].obj)) return; 
    if(buttons[wh].update_script!="")
        add_lua_script_update("c2d:EdyUpdateButton('"+buttons[wh].obj_id+"', " + buttons[wh].update_script + ");");
    if (buttons[wh].lua_enabled_script != "")
        add_lua_script_update("c2d:EdyUpdateButtonEnabled('" + buttons[wh].obj_id + "', " + buttons[wh].lua_enabled_script + ");");
}

function update_button(obj_id, new_value)
{
    document.getElementById(obj_id).btn_lab.innerText = unescape(new_value);
}

function del_button(obj_id)
{
    for(var i = 0; i < buttons_cnt; i++) {
        if (buttons[i].obj_id == obj_id) {
            var element = buttons[i].obj;
            if (element.icon_img)
                element.icon_img.parentNode.removeChild(element.icon_img);
            if (element.btn_lab)
                element.btn_lab.parentNode.removeChild(element.btn_lab);
            element.parentNode.removeChild(element);
            buttons.splice(i, 1);
            buttons_cnt = buttons_cnt - 1;
            break;
        }
    }
}

function add_button(obj_id, label_string, button_width, button_height, lua_on_click, update_script, hint_text, append_to_obj, end_with_new_line, lua_enabled_script, jscript_on_click, icon_image, btn_margin, btn_padding)
{
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    if(jscript_on_click == undefined) jscript_on_click = "";
    if(icon_image == undefined) icon_image = "";
    if (btn_margin == undefined) btn_margin = "";
    if (btn_padding == undefined) btn_padding = "";
    

    var button = document.createElement("button");
    if(obj_id!="")
    {
        buttons[buttons_cnt] = new Object();
        buttons[buttons_cnt].obj_id = obj_id;
        buttons[buttons_cnt].obj = button;
        buttons[buttons_cnt].update_script = update_script;
        buttons[buttons_cnt].lua_enabled_script = lua_enabled_script;
        buttons_cnt = buttons_cnt +1;
    }

    button.id = obj_id;
    button.style.width = button_width;
    button.style.height = button_height;
    button.style.backgroundColor = "#333333";
    button.style.color = c2d_colors_font1;
    button.style.borderWidth = "1px"
    button.style.borderRadius = "4px";
    button.style.boxShadow = c2d_box_shadow;
    button.style.fontFamily = c2d_font;
    button.style.fontStyle = "normal";
    button.style.fontSize = c2d_font_size_normal;
    button.style.cursor = "pointer";
    button.style.borderColor = "#666666";
    button.style.background = c2d_button_blured_bg;
    
    button.onselectstart = function () { return true; }
    if(btn_margin!="") button.style.margin = btn_margin;
    else button.style.margin = "2px";

    if (btn_padding != "") button.style.padding = btn_padding;

    button.style.verticalAlign = "top";

    if(icon_image != "")
    {
        var btn_icon = document.createElement("img");
        btn_icon.src = icon_image + "?" + (new Date()).getTime();
        btn_icon.style.verticalAlign = "middle";
        btn_icon.style.margin = "0px";
        btn_icon.style.padding = "0px";
        button.appendChild(btn_icon);
        button.onselectstart = function () { return true; }
        btn_icon.onmousedown = function () { return true; }
        button.icon_img = btn_icon;
        button.button_icon = btn_icon;
        button.button_icon.id_main_ctrl = obj_id;
    }
    var btn_lab = document.createElement('div');
    button.appendChild(btn_lab);
    button.btn_lab = btn_lab;
    btn_lab.innerText = label_string;
    btn_lab.style.display = "inline";


    button.btn_lab.id_main_ctrl = obj_id;

    button.onmousedown = function() { return true; }
   
    button.onclick = function()
    {
        hidehintbox();
        add_lua_script(lua_on_click);
        my_eval(jscript_on_click);      
    }

    button.onmouseover = function()
    {
        //button.style.backgroundColor = "#444444";
        button.style.background = c2d_button_focused_bg;
        if (hint_text != "") showhintbox(hint_text, this, '', Yes);
    }

    button.onmouseout2 = function()
    {
        //button.style.backgroundColor = "#333333";
        button.style.background = c2d_button_blured_bg;
    }
    button.onmouseout = function() {button.onmouseout2();}


    document.getElementById(append_to_obj).appendChild(button);


    if(end_with_new_line) add_new_line("", append_to_obj);
}

function hide_button(obj_id)
{
    document.getElementById(obj_id).style.display = "none";
}

function show_button(obj_id)
{
    document.getElementById(obj_id).style.display = "inline";
}

function disable_button(obj_id) {
    var btn = document.getElementById(obj_id);
    if (!btn.disabled) {
        btn.disabled = true;
        btn.style.opacity = c2d_colors_opacity_disabled;
    }

}

function enable_button(obj_id) {
    var btn = document.getElementById(obj_id);
    if (btn.disabled) {
        btn.disabled = false;
        btn.style.opacity = 1;
    }
}

function disable_label(obj_id) {
    var label = document.getElementById(obj_id);
    if (!label.disabled) {
        label.disabled = true;
        label.style.opacity = c2d_colors_opacity_disabled;
        if (label.icon_img != undefined) label.icon_img.style.opacity = c2d_colors_opacity_disabled;
    }

}

function enable_label(obj_id) {
    var label = document.getElementById(obj_id);
    if (label.disabled) {
        label.disabled = false;
        label.style.opacity = 1;
        if (label.icon_img != undefined) label.icon_img.style.opacity = 1;
    }
}

function disable_stringbox(obj_id) {
    var string_box = document.getElementById(obj_id);
    if (!string_box.disabled) {
        string_box.disabled = true;
        string_box.style.opacity = c2d_colors_opacity_disabled;
        string_box.value = "";
    }
}

function enable_stringbox(obj_id) {
    var string_box = document.getElementById(obj_id);
    if (string_box.disabled) {
        string_box.disabled = false;
        string_box.style.opacity = 1;
    }
}

function disable_radio(obj_id) {
    var radio = document.getElementById(obj_id);
    if (!radio.disabled) {
        radio.disabled = true;
        radio.radio_label.style.opacity = c2d_colors_opacity_disabled;
        radio.style.opacity = c2d_colors_opacity_disabled;
    }
}

function enable_radio(obj_id) {
    var radio = document.getElementById(obj_id);
    if (radio.disabled) {
        radio.disabled = false;
        radio.radio_label.style.opacity = 1;
        radio.style.opacity = 1;
    }
}

function disable_number(obj_id) {
    var number = document.getElementById(obj_id);
    if (!number.disabled) {
        number.disabled = true;
        number.num_wheel.style.opacity = c2d_colors_opacity_disabled;
        number.style.opacity = c2d_colors_opacity_disabled;
    }
}

function enable_number(obj_id) {
    var number = document.getElementById(obj_id);
    if (number.disabled) {
        number.disabled = false;
        number.num_wheel.style.opacity = 1;
        number.style.opacity = 1;
    }
}

function disable_color(obj_id) {
    var color = document.getElementById(obj_id);
    if (!color.disabled) {
        color.disabled = true;
        color.style.opacity = c2d_colors_opacity_disabled;
    }
}

function enable_color(obj_id) {
    var color = document.getElementById(obj_id);
    if (color.disabled) {
        color.disabled = false;
        color.style.opacity = 1;
    }
}

function disable_texture(obj_id) {
    var texture = document.getElementById(obj_id);
    if (!texture.disabled) {
        texture.disabled = true;
        texture.label.style.opacity = c2d_colors_opacity_disabled;
        texture.label.value = "object not selected";
        texture.style.opacity = c2d_colors_opacity_disabled / 3;
        //texture.style.display = "none";
    }
}

function enable_texture(obj_id) {
    var texture = document.getElementById(obj_id);
    if (texture.disabled) {
        texture.disabled = false;
        texture.label.style.opacity = 1;
        texture.style.opacity = 1;
        //texture.style.display = "inline";

    }
}

function disable_checkbox(obj_id) {
    var checkbox = document.getElementById(obj_id);
    if (!checkbox.disabled) {
        checkbox.disabled = true;
        checkbox.checkbox_label.style.opacity = c2d_colors_opacity_disabled;
        checkbox.style.opacity = c2d_colors_opacity_disabled;
    }
}

function enable_checkbox(obj_id) {
    var checkbox = document.getElementById(obj_id);
    if (checkbox.disabled) {
        checkbox.disabled = false;
        checkbox.checkbox_label.style.opacity = 1;
        checkbox.style.opacity = 1;
    }
}

function disable_slider(obj_id) {
    var slider = document.getElementById(obj_id);
    if (!slider.disabled) {
        slider.disabled = true;
        slider.slider_label.style.opacity = c2d_colors_opacity_disabled;
        slider.style.opacity = c2d_colors_opacity_disabled;
    }
}

function enable_slider(obj_id) {
    var slider = document.getElementById(obj_id);
    if (slider.disabled) {
        slider.disabled = false;
        slider.slider_label.style.opacity = 1;
        slider.style.opacity = 1;
    }
}

function disable_listbox(obj_id) {
    var listbox = document.getElementById(obj_id);
    if (listbox == undefined) return;

    listbox.options.length = 0;
    listbox.disabled = true;
    listbox.style.opacity = c2d_colors_opacity_disabled2;
}

function enable_listbox(obj_id) {
    var listbox = document.getElementById(obj_id);
    listbox.disabled = false;
    listbox.style.opacity = 1;
}

function unhide_block(obj_id) {
    document.getElementById(obj_id).style.display = "inline";
}

function hide_block(obj_id) {
    document.getElementById(obj_id).style.display = "none";
}


// SLIDER

function four_digits(value)
{
    return Math.round(value * 10000) / 10000;
}
function request_update_slider(wh)
{
    if (is_my_ctrl_hidden_now(sliders[wh].obj)) return;

    if (sliders[wh].lua_enabled_script != "")
        add_lua_script_update("c2d:EdyUpdateSliderEnabled('" + sliders[wh].obj_id + "', " + sliders[wh].lua_enabled_script + ");");

    if (sliders[wh].update_script == "") return;
    var lua_script = "c2d:EdyUpdateSlider('" + sliders[wh].obj_id + "', " + sliders[wh].update_script + ");";
    if (sliders[wh].lua_obj_check != "") {
        lua_script = "if(" + sliders[wh].lua_obj_check + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_slider(slider_id, new_value)
{
    document.getElementById(slider_id).value = new_value;
    document.getElementById(slider_id+"_sliderlabel1").childNodes[0].nodeValue = four_digits(new_value);
}

function slider_hide_label(slider_id)
{
    document.getElementById(slider_id).slider_label.style.display = "none"    
}

function add_slider(obj_id, current_value, min_value, max_value, step_value, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line, width, lua_enabled_script, lua_obj_check)
{
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    if (lua_obj_check == undefined) lua_obj_check = "";

    var slider = document.createElement("input");
    slider.type = "range";
    if(obj_id!="")
    {
        sliders[sliders_cnt] = new Object();
        sliders[sliders_cnt].obj_id = obj_id;
        sliders[sliders_cnt].obj = slider;
        sliders[sliders_cnt].update_script = update_script;
        sliders[sliders_cnt].lua_enabled_script = lua_enabled_script;
        sliders[sliders_cnt].lua_obj_check = lua_obj_check;
        sliders_cnt = sliders_cnt +1;
    }
    
    slider.id = obj_id;
    slider.value = current_value;
    slider.min = min_value;
    slider.max = max_value;
    slider.step = step_value;

    if(width=="") width = 175;
    slider.style.width = width;
    
    slider.style.display = 'inline'

    var label_id = obj_id+"_sliderlabel1";
    var label = document.createElement('label')
    label.htmlFor = obj_id;
    label.id = label_id;
    label.style.display = 'inline'
    label.style.color = "white"

    label.appendChild(document.createTextNode(current_value));


    var sldiv = document.createElement("div");
    sldiv.appendChild(slider);
    document.getElementById(append_to_obj).appendChild(sldiv);
    document.getElementById(append_to_obj).appendChild(label);
    
    slider.slider_label = label;

    sldiv.style.display = 'inline';
   
//     var slider_onchange = "";
//     slider_onchange += "hidehintbox(); document.getElementById(\""+label_id+"\").childNodes[0].nodeValue = four_digits(document.getElementById('"+obj_id+"').value);";
//     slider_onchange += "my_eval(\"add_lua_script('"+lua_onchange+"');\");";
    //     slider.setAttribute("onchange", slider_onchange);

    slider.onmousedown = function()
    {
        slider.focus();
        return true;
    }

    slider.onmousewheel = function(event)
    {
        if (scrolling_now()) return false;
        if (control_key_is_down || shift_key_is_down) {
            var i = 0;
            if (event.wheelDelta > 0)
                i = 1;
            else
                i = -1;
            slider.focus();
            slider.value = Number(this.value) + Number(slider.step) * i;
            slider.onchange();
        }
        return false;
    }

    slider.onchange = function () 
    {
        hidehintbox(); 
        document.getElementById(label_id).childNodes[0].nodeValue = four_digits(document.getElementById(obj_id).value);

        var the_lua = lua_onchange;
        the_lua = the_lua.replace(/~VALUE~/g, document.getElementById(obj_id).value);
        add_lua_script(the_lua);
    }
    
    if(hint_text!="")
    {
        slider.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
        label.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    }
    
    if(end_with_new_line) add_new_line("", append_to_obj);
}


// NUMBER

function request_update_number(wh)
{
    if(numbers[wh].update_script=="") return;
    if(is_my_ctrl_hidden_now(numbers[wh].obj)) return;
    if (numbers[wh].obj.my_focus_store) return;

    if (numbers[wh].lua_enabled_script != "") {
        var lua_script = "c2d:EdyUpdateNumberEnabled('" + numbers[wh].obj_id + "', " + numbers[wh].lua_enabled_script + ");";
        add_lua_script_update(lua_script);
    }

    var lua_script = "c2d:EdyUpdateNumber('" + numbers[wh].obj_id + "', " + numbers[wh].update_script + ");";
    if (numbers[wh].lua_enabled_script != "") {
        lua_script = "if(" + numbers[wh].lua_enabled_script + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_number(number_id, new_value)
{
    var num = document.getElementById(number_id);
    num.value = new_value;
    num.num_last_value = new_value;
}

function string_is_a_number(the_number)
{
   return ((the_number - 0) == the_number) && (the_number.length > 0);
}

function add_number(obj_id, current_value, min_value, max_value, step_value, accept_float_number, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line, ctrl_width, ctrl_height, wheel_undo_serie_start_lua, wheel_undo_serie_end_lua, lua_enabled_script)
{
    if (wheel_undo_serie_start_lua == undefined) wheel_undo_serie_start_lua = "";
    if (wheel_undo_serie_end_lua == undefined) wheel_undo_serie_end_lua = "";
    if (lua_enabled_script == undefined) lua_enabled_script = "";

    var number = document.createElement("input");
    number.type = "text";
    if(obj_id!="")
    {
        numbers[numbers_cnt] = new Object();
        numbers[numbers_cnt].obj_id = obj_id;
        numbers[numbers_cnt].obj = number;
        numbers[numbers_cnt].update_script = update_script;
        numbers[numbers_cnt].lua_enabled_script = lua_enabled_script;
        numbers_cnt = numbers_cnt +1;
    }
    
    number.id = obj_id;
    number.value = current_value;
    number.min = min_value;
    number.max = max_value;
    number.step = step_value;
    number.my_focus_store = false;
    number.num_last_value = current_value;

    number.onfocus = function() {this.my_focus_store = true; this.style.backgroundColor = c2d_colors_selected;}
    number.onblur = function() {this.my_focus_store = false; this.style.backgroundColor = c2d_colors_unselected;}

    var c_width = 50; 
    if(ctrl_width!="") c_width = ctrl_width;
    number.style.width = c_width;
    number.style.height = "20px";
    
    number.style.padding = "0px";
    number.style.margin = "0px";
    number.style.verticalAlign = "middle";
    number.style.display = "inline";
    number.style.backgroundColor = c2d_colors_unselected;
    number.style.color = c2d_colors_font1;
    number.style.borderRadius = "3px";
    number.style.boxShadow = c2d_box_shadow;

    number.style.border = "1px solid white";
    number.style.borderColor = c2d_colors_border2;

    number.num_wheel = document.createElement("img");
    number.num_wheel.src = "num_wheel.png";
    number.num_wheel.style.verticalAlign = "middle";
    number.num_wheel.height = 20;
    number.num_wheel.style.cursor = "pointer";
    number.num_wheel.style.borderRadius = "3px";
    number.num_wheel.style.boxShadow = c2d_box_shadow;

    number.wheel_undo_serie_start = function()
    {
        if(wheel_undo_serie_start_lua=="") return;
        add_lua_script(wheel_undo_serie_start_lua);
    }
    
    number.wheel_undo_serie_end = function()
    {
        if(wheel_undo_serie_end_lua=="") return;
        add_lua_script(wheel_undo_serie_end_lua);
    }
    
    number.onmousedown = function (event) 
    {
        return true;
    }
    
    number.onmousewheel = function (event)
    {
        if (scrolling_now()) return false;
        if (number.disabled) return false;
        if (control_key_is_down || shift_key_is_down) {
            var i = 0;
            if (event.wheelDelta > 0)
                i = 1;
            else
                i = -1;
            number.focus();
            number.wheel_update_value(i);
        }
        return false;
    }

    number.num_wheel.onmousewheel = number.onmousewheel;

    number.num_wheel.onmousedown = function (event) 
    {
        // editing the number with mouse
        if(number.disabled) return;
        number.focus();
        start_num_wheel(number); 
        return false; 
    }
//     number.onmousedown = function(event) {number.focus();}
//     number.onselectstart = function() { return true;}
    
//     number.num_wheel.onmousemove = function (event) { number.value = event.clientY; return true; }
//     number.num_wheel.onmouseout = function (event) { return false; }

    var mdivv = document.createElement("table");
    mdivv.cellPadding = "0px";
    mdivv.cellSpacing = "0px";
    mdivv.style.margin = "1px";
    mdivv.style.padding = "0px";
    mdivv.style.marginRight = "3px";
    mdivv.style.border = "0px solid black";
    mdivv.style.verticalAlign = "middle";
    mdivv.style.display = "inline";
    
    mdivv.appendChild(number);
    
    mdivv.appendChild(number.num_wheel);
    
    document.getElementById(append_to_obj).appendChild(mdivv);

    number.wheel_update_value = function(steps)
    {
        var the_num = Number(number.value);
        var the_step = Number(number.step);
        the_num = the_num + Number(steps) * the_step;
        if(number.min<number.max)
        {
            if(the_num<number.min) the_num = number.min;
            else if(the_num>number.max) the_num = number.max;
        }
        number.value = the_num;
        number.style.backgroundColor = c2d_colors_selected;
        var lua_onchange_script = lua_onchange;
        lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, the_num);
        add_lua_script(lua_onchange_script);
        number.num_last_value = number.value;
    }
    

    number.onkeydown = function(evt)
    {
        hidehintbox();
    
        // this function helps to accept numbers only
        var charCode = (evt.which) ? evt.which : evt.keyCode;

        if(charCode==8) return true; // backspace
        if(charCode==46) return true; // delete
        
        if(charCode==38) // arrow up
        {
            this.wheel_update_value(1); 
            return false;
        }
        if(charCode==40) // arrow down
        {
            this.wheel_update_value(-1); 
            return false;
        }
        
        if((charCode==37) || (charCode<=39)) return true; // arrows left and right
        if((charCode>=33) && (charCode<=36)) return true; // home, end, page down and page down
        if((charCode==109) || (charCode==189)) // minus on num pad
        {
            if(this.value==0)
            {
                this.value="-";
                return false;
            }
            this.value = -this.value;
            return false; 
        }
        if((charCode >= 48) && (charCode <= 57)) return true; // numbers
        if((charCode >= 96) && (charCode <= 105)) return true; // numbers on num pad

        if(accept_float_number)
        {
            if((charCode==190) || (charCode==110)) // point or point on keypad
            {
                var value_string = this.value;
                if(value_string.indexOf(".")!=-1) return false; // there's already a point in a number
                if(value_string=="-")
                {
                    this.value = "-0";
                    return true;
                }
                return true;
            }
        }

        // when enter is pressed, we accept and send new value
        if((charCode==13) || (charCode==108) || (charCode==9)) // enter or enter on keypad or TAB
        {
        }

        //number.value = number.value + charCode;
        if (control_key_is_down) {
            if ((charCode == 67) || (charCode == 86) || (charCode == 45)) {
                // ctrl +c, v, insert
                return true;
            }
        }
        if (shift_key_is_down) {
            if (charCode == 45) {
                // shift + insert
                return true;
            }
        }

        // all other keys are not accepted
        return false;
    }

    number.onkeyup = function(evt)
    {
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if(charCode==9) return true;
        if(string_is_a_number(this.value)) 
        {
            if (number.num_last_value != this.value) {
                var the_num = Number(this.value);
                if (this.min < this.max) {
                    if ((the_num < this.min) || (the_num > this.max)) {
                        // number not in min/max interval
                        this.style.backgroundColor = c2d_colors_bg_red;
                        return false;
                    }
                }
                // everything ok, let's send lua script with the number
                this.style.backgroundColor = c2d_colors_selected;
                //this.value = the_num;
                //document.getElementById("my_helpy_label").innerHTML = ;

                var lua_onchange_script = lua_onchange;
                lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, the_num);
                add_lua_script(lua_onchange_script);
                number.num_last_value = this.value;
            }
        }
        else 
        {
            this.style.backgroundColor = c2d_colors_bg_red;
            return false; // not a number
        }
    }

    if (hint_text != "") number.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };

    if(end_with_new_line) add_new_line("", append_to_obj);
}


// STRINGBOX

function request_update_stringbox(wh)
{
    if(is_my_ctrl_hidden_now(stringboxes[wh].obj)) return;

    if (stringboxes[wh].lua_enabled_script != "") {
        var lua_script = "c2d:EdyUpdateStringBoxEnabled('" + stringboxes[wh].obj_id + "', " + stringboxes[wh].lua_enabled_script + ");";
        add_lua_script_update(lua_script);
    }
    if(stringboxes[wh].update_script=="") return;
    if (stringboxes[wh].obj.my_focus_store) return;
    var lua_script = "c2d:EdyUpdateStringBox('" + stringboxes[wh].obj_id + "', " + stringboxes[wh].update_script + ");";
    if (stringboxes[wh].lua_obj_check != "") {
        lua_script = "if(" + stringboxes[wh].lua_obj_check + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_stringbox(stringbox_id, new_value)
{
    document.getElementById(stringbox_id).value = new_value;
}

function add_stringbox(obj_id, current_value, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line, ctrl_width, ctrl_height, max_string_length, lua_enabled_script, lua_obj_check, allow_all_chars)
{
    var stringbox = document.createElement("input");
    if (allow_all_chars == undefined) allow_all_chars = false;
    if (allow_all_chars == "") allow_all_chars = false;

    stringbox.type = "text";
    if(obj_id!="")
    {
        stringboxes[stringboxes_cnt] = new Object();
        stringboxes[stringboxes_cnt].obj_id = obj_id;
        stringboxes[stringboxes_cnt].obj = stringbox;
        stringboxes[stringboxes_cnt].update_script = update_script;
        if(lua_enabled_script==undefined) lua_enabled_script = "";
        stringboxes[stringboxes_cnt].lua_enabled_script = lua_enabled_script;
        if (lua_obj_check == undefined) lua_obj_check = "";
        stringboxes[stringboxes_cnt].lua_obj_check = lua_obj_check;
        stringboxes_cnt = stringboxes_cnt +1;
    }
    
    stringbox.id = obj_id;
    stringbox.value = current_value;
    stringbox.my_focus_store = false;
    if (max_string_length != "") stringbox.maxLength = max_string_length;

    stringbox.allow_all_chars = allow_all_chars;
    
    stringbox.style.backgroundColor = c2d_colors_unselected;
    stringbox.style.color = c2d_colors_font1;
    stringbox.style.border = "1px solid"
    stringbox.style.borderRadius = "2px";
    stringbox.style.borderColor = c2d_colors_border2;
    stringbox.style.boxShadow = c2d_box_shadow;
    stringbox.onfocus = function() {this.my_focus_store = true; this.style.backgroundColor = c2d_colors_selected;}
    stringbox.onblur = function() {this.my_focus_store = false; this.style.backgroundColor = c2d_colors_unselected;}
    
    stringbox.style.fontFamily = c2d_font;
    stringbox.style.fontStyle = "normal";
    stringbox.style.fontSize = c2d_font_size_normal;

    var c_width = 50; 
    if(ctrl_width!="") c_width = ctrl_width;
    stringbox.style.width = c_width;
    if(ctrl_height!="") stringbox.style.height = ctrl_height;
    
    

    var mdivv = document.getElementById(append_to_obj);
    mdivv.appendChild(stringbox);
    
    stringbox.onmousedown = function () { return true; }

    stringbox.onkeydown = function (evt) {
        if (!stringbox.allow_all_chars) {
            // pg up, pg down, home, end and arrows:
            if ((evt.keyCode >= 33) && (evt.keyCode <= 40))
                return true;
            // insert, del and backspace
            if ((evt.keyCode == 45) || (evt.keyCode == 46) || (evt.keyCode == 8))
                return true;
            // ctrl and shift (left and right)
            if ((evt.keyCode >= 160) && (evt.keyCode <= 163))
                return true;
            // TAB
            if (evt.keyCode == 9)
                return true;
            // space
            if (evt.keyCode == 32) {
                if (this.selectionStart == 0)
                    return false; //
                return true;
            }
            // numbers
            if ((evt.keyCode >= 48) && (evt.keyCode <= 57))
                return true;
            // num keys
            if ((evt.keyCode >= 65) && (evt.keyCode <= 90))
                return true;
            // A..Z
            return false;

            //this.value = this.value + evt.which.toString()
            //this.selectionStart = 1;
            //this.selectionEnd = 1;
        }
    }

    stringbox.onkeyup = function (evt)
    {
        if (!stringbox.allow_all_chars) {
            var startPos = this.selectionStart;
            var changed = false;
            for(var i = this.value.length - 1; i >= 0; i--) {
                var chr = this.value.charAt(i);
                var chrb = ' ';
                if (i > 0) chrb = this.value.charAt(i - 1);
                if (chrb == ' ') {
                    if ((chr >= 'a') && (chr <= 'z')) {
                        this.value = this.value.substring(0, i) + chr.toUpperCase() + this.value.substring(i + 1);
                        changed = true;
                    }
                }

                var valid_char = ((chr >= 'a') && (chr <= 'z')) || ((chr >= 'A') && (chr <= 'Z'))
                    || ((chr >= '0') && (chr <= '9')) || (chr == ' ');
                if (!valid_char) {
                    this.value = this.value.substring(0, i) + this.value.substring(i + 1);
                    changed = true;
                    if (i < startPos)
                        startPos--;
                }
            }

            if (changed) {
                this.selectionStart = startPos;
                this.selectionEnd = startPos;
            }
        }


        hidehintbox();
        // send string value
        if(lua_onchange != "")
        {
            var lua_onchange_script = lua_onchange;
            lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, "\""+escape(this.value)+"\"");
            add_lua_script(lua_onchange_script);
        }
        if(stringbox.maxLength>0)
        if(this.value.toString().length>=stringbox.maxLength)
        {
            showhintbox_imm("<b> UP TO "+stringbox.maxLength+" CHARACTERS ONLY ! <b>", this, '');
        }
        return true;
    }


    if (hint_text != "") stringbox.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };

    if(end_with_new_line) add_new_line("", append_to_obj);
}

// TEXTBOX

function request_update_textbox(wh)
{
    if(textboxes[wh].update_script=="") return;
    if(is_my_ctrl_hidden_now(textboxes[wh].obj)) return; 
    if(textboxes[wh].obj.my_focus_store) return;
    add_lua_script_update("c2d:EdyUpdateTextbox('"+textboxes[wh].obj_id+"', " + textboxes[wh].update_script + ");");
}

function update_textbox(textbox_id, new_value)
{
    var texarea = document.getElementById(textbox_id);
    texarea.value = unescape(new_value); // we need to get here escaped string and we unescape it

    if(texarea.autorows)
    {
        var text = texarea.value;
        var num_lines = 1 + (text.match(/\n/g)||[]).length;
        texarea.rows = num_lines;
    }
}

function add_textbox(obj_id, current_value, rows_count, box_width, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line)
{
    var textbox = document.createElement("textarea");
    if(obj_id!="")
    {
        textboxes[textboxes_cnt] = new Object();
        textboxes[textboxes_cnt].obj_id = obj_id;
        textboxes[textboxes_cnt].obj = textbox;
        textboxes[textboxes_cnt].update_script = update_script;
        textboxes_cnt = textboxes_cnt +1;
    }
    
    //textbox.setAttribute('wrap', 'off');
    textbox.id = obj_id;
    textbox.value = current_value;
    textbox.readonly = false;
    textbox.rows = rows_count;
    textbox.autorows = (rows_count == "auto");
    //textbox.cols = 10;
    textbox.style.width = box_width;
    textbox.style.backgroundColor = c2d_colors_unselected;

    textbox.my_focus_store = false;
    textbox.onfocus = function () {
        this.my_focus_store = true; this.style.backgroundColor = c2d_colors_selected;
    }
    textbox.onblur = function () {
        this.my_focus_store = false; this.style.backgroundColor = c2d_colors_unselected;
    }

    var mdivv = document.getElementById(append_to_obj);
    mdivv.appendChild(textbox);
    
    textbox.onmousedown = function() { return true; }
    
    textbox.onkeyup = function(evt)
    {
        hidehintbox();
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        
        //if(charCode==9) return false; // TAB key not accepted
        
        //if((charCode==13) || (charCode==108) || (charCode==9)) // enter or enter on keypad or TAB
        {
            var lua_onchange_script = lua_onchange;
            //lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, "\""+escape_string_for_lua(this.value)+"\"");
            lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, "\""+escape(this.value)+"\"");
            add_lua_script(lua_onchange_script);
        }

        // key is accepted
        return true;
    }
    
    if (hint_text != "") textbox.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    
    if(end_with_new_line) add_new_line("", append_to_obj);
}


// COLOR

function request_update_color(wh)
{
    if(colors[wh].update_script=="") return;
    if(is_my_ctrl_hidden_now(colors[wh].obj)) return; 

    if (colors[wh].lua_enabled_script != "") {
        var lua_script = "c2d:EdyUpdateColorEnabled('" + colors[wh].obj_id + "', " + colors[wh].lua_enabled_script + ");";
        add_lua_script_update(lua_script);
    }

    var lua_script = "c2d:EdyUpdateColor('" + colors[wh].obj_id + "', " + colors[wh].update_script + ");"
    if (colors[wh].lua_enabled_script != "") {
        lua_script = "if(" + colors[wh].lua_enabled_script + ") then " + lua_script + " end;"
    }
    add_lua_script_update(lua_script);
}

function update_color(obj_id, red, green, blue, alpha)
{
    var btn = document.getElementById(obj_id)
    btn.style.backgroundColor = "rgb("+red+","+green+","+blue+")";
    if(parseInt(red)+parseInt(green)+parseInt(blue)>384) btn.style.color = "#000000"; else btn.style.color = "#FFFFFF";
    if(alpha != 256)
    {
        btn.value = btn.label_string + " (A:" + alpha + ")"
    }
}

function add_color(obj_id, label_string, width, height, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line, lua_undo_start_serie, lua_undo_end_serie, color_name, lua_enabled_script)
{
    if (lua_undo_start_serie==undefined) lua_undo_start_serie="";
    if (lua_undo_end_serie==undefined) lua_undo_end_serie="";
    if (color_name == undefined) color_name = "";
    if (lua_enabled_script == undefined) lua_enabled_script = "";

    var color = document.createElement('input')
    color.type = "button";
    color.style.cursor = "pointer";
    if(obj_id!="")
    {
        colors[colors_cnt] = new Object();
        colors[colors_cnt].obj_id = obj_id;
        colors[colors_cnt].obj = color;
        colors[colors_cnt].update_script = update_script;
        colors[colors_cnt].lua_enabled_script = lua_enabled_script;
        colors_cnt = colors_cnt +1;
    }

    color.id = obj_id
    color.value = label_string
    color.label_string = label_string
    color.style.border = "1px solid #333333";
    color.style.fontFamily = c2d_font;
    color.style.fontStyle = "normal";
    color.style.borderRadius = "4px";
    color.style.boxShadow = c2d_box_shadow;
    color.style.fontSize = c2d_font_size_normal;
    if (width != "") color.style.width = width; else if (label_string == "") color.style.width = 60
    if(height!="") color.style.height = height; else if(label_string=="") color.style.height = 30
    color.style.backgroundColor = "rgb(255,255,255)"
    document.getElementById(append_to_obj).appendChild(color)

    if (hint_text != "") color.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    
    //color.setAttribute("onclick", "hidehintbox(); add_lua_script(\"c2d:ColorPickStart(\'"+lua_onchange+"\',"+update_script+",\'"+lua_undo_start_serie+"\',\'"+lua_undo_end_serie+"\')\")");
    
   
    color.onclick = function () 
    {
        hidehintbox(); 
        add_lua_script("c2d:ColorPickStart('"+escape(lua_onchange)+"',"+update_script+",'"+escape(lua_undo_start_serie)+"','"+escape(lua_undo_end_serie)+"','"+escape(update_script)+"','"+escape(color_name)+"')");
    }
    
    if(end_with_new_line) add_new_line("", append_to_obj);

}


// LABEL

function request_update_label(wh)
{
    if (!labels[wh].obj.my_jscript_on_control_update)
        if (is_my_ctrl_hidden_now(labels[wh].obj)) return;

    if (labels[wh].lua_enabled_script != "")
        add_lua_script_update("c2d:EdyUpdateLabelEnabled('" + labels[wh].obj_id + "', " + labels[wh].lua_enabled_script + ");");

    if (labels[wh].update_script == "") return;
    var lua_script = "c2d:EdyUpdateLabel('" + labels[wh].obj_id + "', " + labels[wh].update_script + ");";
    if (labels[wh].lua_enabled_script != "") {
        lua_script = "if(" + labels[wh].lua_enabled_script + ") then " + lua_script + " end"
    }
    add_lua_script_update(lua_script);
}

function update_label(obj_id, new_value)
{
    var label = document.getElementById(obj_id);
    new_value = unescape(new_value);
    if(label.readOnly) label.value = new_value; // is input
    else label.innerHTML = new_value; // is label
    if(label.my_jscript_on_control_update) eval(label.my_jscript_on_control_update);
}

function del_label(obj_id)
{
    for(var i = 0; i < labels_cnt; i++) {
        if (labels[i].obj_id == obj_id) {
            var element = labels[i].obj;
            element.parentNode.removeChild(element);
            labels.splice(i, 1);
            labels_cnt = labels_cnt - 1;
            break;
        }
    }
}

function add_label(obj_id, label_string, update_script, hint_text, append_to_obj, end_with_new_line, label_width, icon_img, lua_enabled_script)
{
    if(icon_img==undefined) icon_img = "";
    if (lua_enabled_script == undefined) lua_enabled_script = "";

    var wtype = 0;
    if(label_width != undefined) if(label_width != "") wtype = 1;
    
    var label;
    if(wtype == 0)
    {
         label = document.createElement('label');
         label.innerHTML = label_string;
         //label.style.borderBottom = "1px solid rgba(0,0,0,0.5)";
         //label.onselectstart = "return true;"
     }
    else
    {
        label = document.createElement('input');
        label.type = "text";
        label.style.backgroundColor = "transparent";
        label.style.border = "none";
        label.readOnly = true;
        label.style.fontFamily = c2d_font;
        label.style.fontStyle = "normal";
        label.style.fontSize = c2d_font_size_normal;
        label.style.width = label_width;
        label.tabIndex = -1;
        label.value = label_string;
    }
    
    label.style.color = c2d_colors_font1;
    
    label.id = obj_id;
    
    if(obj_id!="")
    {
        labels[labels_cnt] = new Object();
        labels[labels_cnt].obj_id = obj_id;
        labels[labels_cnt].obj = label;
        labels[labels_cnt].update_script = update_script;
        labels[labels_cnt].lua_enabled_script = lua_enabled_script;
        labels_cnt = labels_cnt +1;
    }

    if(icon_img!="")
    {
        var img = document.createElement("img");
        img.src = icon_img;
        document.getElementById(append_to_obj).appendChild(img);
        label.icon_img = img;
        label.icon_img.id_main_ctrl = obj_id;
    }
    document.getElementById(append_to_obj).appendChild(label);

    if (hint_text != "") label.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    
    if(end_with_new_line) add_new_line("", append_to_obj);

}


//TEXTURE

function request_update_texture(wh)
{
    if(textures[wh].update_script=="") return;
    if(is_my_ctrl_hidden_now(textures[wh].obj)) return; 

    if (textures[wh].lua_enabled_script != "")
        add_lua_script_update("c2d:EdyUpdateTextureEnabled('" + textures[wh].obj_id + "', " + textures[wh].lua_enabled_script + ");");

    if (textures[wh].update_script == "") return;
    var lua_script = "";
    if (textures[wh].obj.lua_get_multitex == "")
        lua_script = "c2d:EdyUpdateTexture('" + textures[wh].obj_id + "', " + textures[wh].update_script + ");";
    else
        lua_script = "c2d:EdyUpdateTexture('" + textures[wh].obj_id + "', " + textures[wh].update_script + "," + textures[wh].obj.lua_get_multitex + ");";

    if (textures[wh].lua_enabled_script != "") {
        lua_script = "if(" + textures[wh].lua_enabled_script + ") then " + lua_script + " end"
    }
    add_lua_script_update(lua_script);

}

function refresh_all_textures_picture()
{
    for(var i=0; i<textures_cnt; i++)
    {
        var tex = document.getElementById(textures[i].obj_id);
        if(tex)
        {
            tex.wanna_refresh = true;
        }
    }
}

function update_texture(obj_id, texture_fn, frags_x, frags_y, pntcrop_x, pntcrop_y, pntcrop_w, pntcrop_h) 
{
    if(frags_x==undefined) frags_x = 1;
    if(frags_y==undefined) frags_y = 1;

    if((pntcrop_x==undefined) || (pntcrop_y==undefined) || (pntcrop_w==undefined) || (pntcrop_h==undefined))
    {
        pntcrop_x = 0;
        pntcrop_y = 0;
        pntcrop_w = 0;
        pntcrop_h = 0;
    }

    texture_fn = unescape(texture_fn);
    texture_fn = texture_fn.replace(/\\/gi, '/');  // replace all \ to /
    var texture = document.getElementById(obj_id);
    
    // check if we really need to update the picture:
    if((texture.texture_src_fn == texture_fn) 
        && (texture.shown_frags_x == frags_x) 
        && (texture.shown_frags_y == frags_y) 
        && (texture.shown_pntcrop_x == pntcrop_x) 
        && (texture.shown_pntcrop_y == pntcrop_y) 
        && (texture.shown_pntcrop_w == pntcrop_w) 
        && (texture.shown_pntcrop_h == pntcrop_h)
        && (!texture.wanna_refresh))
        return;

    texture.wanna_refresh = false;
    texture.texture_src_fn = texture_fn;
    texture.shown_frags_x = frags_x;
    texture.shown_frags_y = frags_y;
    texture.shown_pntcrop_x = pntcrop_x;
    texture.shown_pntcrop_y = pntcrop_y;
    texture.shown_pntcrop_w = pntcrop_w;
    texture.shown_pntcrop_h = pntcrop_h;
    
    //texture.updating_rect_now = false;
    
    if(texture_fn == "") 
    {
        texture.width = 0;
        texture.height = 0;
        texture.label.value = "(!none)";
        return;
    }

    delete texture.img_loader; // it's important to delete and re-create img_loader
    texture.img_loader = new Image();
    
    texture.img_loader.onerror = function ()
    {
        texture.width = 0;
        texture.height = 0;
        texture.label.value = "(error loading img)";
        texture.texture_src_fn = "";
    }
    
    texture.img_loader.onload = function () 
    {
        // picture is loaded, let's resize or crop it if needed

        var c_w = texture.img_loader.width;
        var c_h = texture.img_loader.height;
        var crop_x = 0;
        var crop_y = 0;
        var crop_w = texture.img_loader.width;
        var crop_h = texture.img_loader.height;
        
        if(texture.size_zoom!=0)
        {
            texture.max_show_width = c_w * texture.size_zoom;
            texture.max_show_height = c_h * texture.size_zoom;
        }
        
        texture.orig_width = texture.img_loader.width;
        texture.orig_height = texture.img_loader.height;

        texture.aspect_to_max_size = 1;
        if ((texture.orig_width > texture_max_size_engine) || (texture.orig_height > texture_max_size_engine))
        {
            if (texture.orig_width > texture.orig_height)
                texture.aspect_to_max_size = texture_max_size_engine / texture.orig_width;
            else texture.aspect_to_max_size = texture_max_size_engine / texture.orig_height;
        }

        
        var rest_w = 0;
        var rest_h = 0;

        if((texture.crop_w>0) && (texture.crop_h>0))
        {
            c_w = texture.crop_w;
            c_h = texture.crop_h;
            crop_x = texture.crop_x;
            crop_y = texture.crop_y;
            crop_w = texture.crop_w;
            crop_h = texture.crop_h;
            if(texture.crop_x+crop_w > texture.img_loader.width) 
            {
                crop_w = texture.img_loader.width - texture.crop_x;
                if(crop_w<0) crop_w = 0;
                rest_w = texture.crop_x + texture.crop_w - texture.img_loader.width;
            }
            if(texture.crop_y+crop_h > texture.img_loader.height) 
            {
                crop_h = texture.img_loader.height - texture.crop_y;
                if(crop_h<0) crop_h = 0;
                rest_h = texture.crop_y + texture.crop_h - texture.img_loader.height;
            }
        }
        var w = 1; if(c_w > texture.max_show_width) w = texture.max_show_width / c_w;
        var h = 1; if(c_h > texture.max_show_height) h = texture.max_show_height / c_h;
        if((w!=1) || (h!=1)) {if(h<w) w = h;} // w is now how we scale image to fit in max width and height
        texture.width = c_w * w;
        texture.height = c_h * w;
        if((rest_w>0) || (rest_h>0))
        {
            // the crop rect goes beyond the picture, let's fill this area red
            texture.getContext("2d").fillStyle="#FF0000";
            var wx = texture.width-rest_w*w; if(wx<0) wx=0;
            var wy = texture.height-rest_h*w; if(wy<0) wy=0;
            texture.getContext("2d").fillRect(wx,0,texture.width, texture.height);
            texture.getContext("2d").fillRect(0,wy,texture.width, texture.height);
        }
        // draw loaded picture data cropped and/or resized as needed:
        texture.imgdrw_x = crop_x;
        texture.imgdrw_y = crop_y;
        texture.imgdrw_w = crop_w;
        texture.imgdrw_h = crop_h;
        texture.imgdrw_xx = texture.width-rest_w*w;
        texture.imgdrw_yy = texture.height-rest_h*w;

        texture.getContext("2d").drawImage(texture.img_loader, texture.imgdrw_x, texture.imgdrw_y, texture.imgdrw_w, texture.imgdrw_h, 0, 0, texture.imgdrw_xx, texture.imgdrw_yy);
        
        if((frags_x != 1) || (frags_y != 1))
        {
            // draw multi-texture fragments
            var ctx=texture.getContext("2d");
            ctx.strokeStyle="#FF0000";
            var w;
            for(var i=1; i<frags_x; i++)
            {
                w = i*texture.width/frags_x;
                ctx.beginPath();
                ctx.moveTo(w,0);
                ctx.lineTo(w,texture.height);
                ctx.stroke();
            }
            for(var i=1; i<frags_y; i++)
            {
                w = i*texture.height/frags_y;
                ctx.beginPath();
                ctx.moveTo(0,w);
                ctx.lineTo(texture.width,w);
                ctx.stroke();
            }
            
        }
        
        if((pntcrop_w > 0) && (pntcrop_h > 0))
        {
            // draw crop of crop picture by point
            var ctx=texture.getContext("2d");
            ctx.strokeStyle="#FF0000";
            ctx.beginPath();
            
            var pntcrw = w * pntcrop_w / texture.aspect_to_max_size;
            var pntcrh = w * pntcrop_h / texture.aspect_to_max_size;
            var pntcrx = w * pntcrop_x / texture.aspect_to_max_size;
            var pntcry = w * (texture.img_loader.height * texture.aspect_to_max_size - 1 - pntcrop_y) / texture.aspect_to_max_size; // flip y to cartesian
            pntcry = pntcry - pntcrh;
            
            ctx.moveTo(pntcrx, pntcry);
            ctx.lineTo(pntcrx + pntcrw, pntcry);
            ctx.lineTo(pntcrx + pntcrw, pntcry + pntcrh);
            ctx.lineTo(pntcrx, pntcry + pntcrh);
            ctx.lineTo(pntcrx, pntcry);
            ctx.stroke();
        }
    }
    
    var load_fn = texture_fn;

    var colon_index = texture_fn.indexOf(":",0);

    var pntcropsign_index = texture_fn.indexOf(">",0);

    var pid_index = load_fn.indexOf("|",0);
    if(pid_index != -1) load_fn = load_fn.substr(0,pid_index); // we put away the |PID parameter that should be at the end
    
    if(pntcropsign_index != -1)
    {
        load_fn = texture_fn.substr(0,pntcropsign_index);
        texture.crop_x = 0;
        texture.crop_y = 0;
        texture.crop_w = 0;
        texture.crop_h = 0;
    }
    else if(colon_index != -1)
    {
        // get texture crop rect
        var crop_str = load_fn.substr(colon_index+1);
        var jpos = 0;

        texture.crop_x = Number( crop_str.substring(jpos, crop_str.indexOf(",",jpos+1)) ); 
        jpos = crop_str.indexOf(",",jpos+1) + 1;
        texture.crop_y = Number( crop_str.substring(jpos, crop_str.indexOf(",",jpos+1)) );
        jpos = crop_str.indexOf(",",jpos+1) + 1;
        texture.crop_w = Number( crop_str.substring(jpos, crop_str.indexOf(",",jpos+1)) );
        jpos = crop_str.indexOf(",",jpos+1) + 1;
        texture.crop_h = Number( crop_str.substring(jpos) );
        load_fn = texture_fn.substr(0,colon_index);
    }
    else
    {
        // no texture crop
        texture.crop_x = 0;
        texture.crop_y = 0;
        texture.crop_w = 0;
        texture.crop_h = 0;
    }
    
    // texture label
    if((texture_fn[0]=='.') && (texture_fn[1]=='.'))
        texture.label.value = extract_filename(texture_fn);
    else texture.label.value = texture_fn; // texture.crop_x + "," + texture.crop_y + "," + texture.crop_w + "," + texture.crop_h;// + Math.random();

    load_fn = escape(load_fn);
    var load_url = textures_root_directory + load_fn;
    // this little hack with '?' and getTime avoids using the images cached in browser and loads image every time instead
    load_url = load_url + "?" + (new Date()).getTime(); 
    
    // load picture now:
    texture.img_loader.src = load_url;
}

function texture_resize(obj_id, resize_width, resize_height) 
{
    var texture = document.getElementById(obj_id);
    if((texture.width == resize_width) && (texture.height == resize_height)) return;
    texture.width = resize_width;
    texture.height = resize_height;
    texture.max_show_width = resize_width;
    texture.max_show_height = resize_height;
    texture.wanna_refresh = true;
    update_texture(obj_id, escape(texture.texture_src_fn), 1, 1, 0, 0, 0, 0) 
}

function texture_anim_resize(obj_id, resize_width, resize_height) 
{
    var texture = document.getElementById(obj_id);
    texture.anim_resize_w = resize_width;
    texture.anim_resize_h = resize_height;
    texture.anim_resize_timer = setTimeout("texture_anim_resize_timer('"+obj_id+"')", 30);
}

function texture_anim_resize_timer(obj_id)
{
    var texture = document.getElementById(obj_id);
    //texture.getContext("2d").scale(0.5,0.5);
    var w = texture.anim_resize_w - texture.width;
    var h = texture.anim_resize_h - texture.height;
    if((w==0) && (h==0)) return;
    if((w>2) || (w<-2)) w = w * 0.5;
    if((h>2) || (h<-2)) h = h * 0.5;
    var nw = w + texture.width;
    var nh = h + texture.height;
    texture.width = nw;
    texture.height = nh;
    texture.max_show_width = nw;
    texture.max_show_height = nh;
    texture.wanna_refresh = true;
    update_texture(obj_id, escape(texture.texture_src_fn), 1, 1, 0, 0, 0, 0) 
    texture.anim_resize_timer = setTimeout("texture_anim_resize_timer('"+obj_id+"')", 30);
}

function del_texture(obj_id)
{
    for(var i=0; i<textures_cnt; i++)
    {
        if(textures[i].obj_id == obj_id)
        {
            var element = textures[i].texlabel;
            element.parentNode.removeChild(element);
            var element = textures[i].obj;
            element.parentNode.removeChild(element);
            textures.splice(i, 1);
            textures_cnt = textures_cnt - 1;
            break;
        }
    }
}

function add_texture(obj_id, tex_fn, max_show_width, max_show_height, update_script, hint_text, append_to_obj, end_with_new_line, border, hide_texture_label, lua_update_rect, lua_get_multitex, drag_item_type, drag_item_value, lua_set_crop_point, zoom_view, lua_enabled_script)
{
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    var texture = document.createElement('canvas');
    var br = document.createElement('br');
    var texlabel = document.createElement('input');
    texlabel.type = "text";
    texture.new_line = br;
    texture.label = texlabel;
    if (obj_id != "")
    {
        textures[textures_cnt] = new Object();
        textures[textures_cnt].obj_id = obj_id;
        textures[textures_cnt].obj = texture;
        textures[textures_cnt].texlabel = texlabel;
        textures[textures_cnt].update_script = update_script;
        textures[textures_cnt].lua_enabled_script = lua_enabled_script;
        textures_cnt = textures_cnt + 1;
    }
    
    if(lua_update_rect == undefined) lua_update_rect = "";
    if(lua_set_crop_point == undefined) lua_set_crop_point = "";
    if(lua_get_multitex == undefined) lua_get_multitex = "";
    if(drag_item_type == undefined) drag_item_type = "";
    if(drag_item_value == undefined) drag_item_value = "";
    if(zoom_view == undefined) zoom_view = 0;


    texture.width = max_show_width;
    texture.height = max_show_height;
    texture.id = obj_id;
    texture.style.border = border;//"1px solid black";
    texture.style.borderRadius = "4px";
    texture.style.boxShadow = c2d_box_shadow;
    texture.texture_src_fn = "";
    texture.wanna_refresh = false;
    texture.size_zoom = zoom_view;

    texture.hint_text = hint_text;

    texture.shown_frags_x = 1;
    texture.shown_frags_y = 1;

    texture.shown_pntcrop_x = 0;
    texture.shown_pntcrop_y = 0;
    texture.shown_pntcrop_xx = 0;
    texture.shown_pntcrop_yy = 0;

    texture.max_show_width = max_show_width;
    texture.max_show_height = max_show_height;
    texture.img_loader = new Image();
    texture.lua_update_rect = lua_update_rect;
    if(lua_update_rect!="") texture.style.cursor = "crosshair";
    texture.lua_set_crop_point = lua_set_crop_point;
    if(lua_set_crop_point!="") texture.style.cursor = "crosshair";
    texture.lua_get_multitex = lua_get_multitex;
//     texture.updating_rect_now = false;
//     texture.updating_rect_px = 0;
//     texture.updating_rect_py = 0;
//     texture.updating_rect_pxx = 0;
//     texture.updating_rect_pyy = 0;

    texture.picking_crop_by_point = false;
    texture.picking_crop_by_point_x = 0;
    texture.picking_crop_by_point_y = 0;
    texture.mouse_downed_x = 0;
    texture.mouse_downed_y = 0;

    texture.label.style.backgroundColor = "transparent";
    texture.label.style.border = "1px dotted grey";
    texture.label.readOnly = true;
    texture.label.style.fontFamily = c2d_font;
    texture.label.style.fontStyle = "normal";
    texture.label.style.fontSize = c2d_font_size_normal;
    texture.label.style.width = max_show_width;
    texture.label.style.color = c2d_colors_font1;
    texture.label.tabIndex = -1;
    if(hide_texture_label) 
    {
        texture.label.my_control_leave_hidden = true;
        texture.label.style.display = "none";
        texture.new_line.my_control_leave_hidden = true;
        texture.new_line.style.display = "none";
    }

    texture.drag_item_type = drag_item_type;
    texture.drag_item_value = drag_item_value;
    texture.may_start_drag = false;

//     texture.label = document.createElement('label'); // label
//     texture.label.appendChild(document.createElement("br"));
//     texture.label.appendChild(document.createTextNode(""));
//     texture.label.style.width = max_show_width;
//     texture.label.style.maxWidth = max_show_width;
//     texture.label.style.display = 'block';
//     if(hide_texture_label) 
//     {
//         texture.label.my_control_leave_hidden = true;
//         texture.label.style.display = "none";
//     }
    
    document.getElementById(append_to_obj).appendChild(texture);
    document.getElementById(append_to_obj).appendChild(texture.new_line);
    document.getElementById(append_to_obj).appendChild(texture.label);

    update_texture(obj_id, tex_fn, 1, 1, 0, 0, 0, 0) 
    
    texture.start_drag_now = function () {
        dragging_item_type = drag_item_type;
        if (drag_item_value == "")
            dragging_item_value = escape(texture.texture_src_fn)
        else
            dragging_item_value = drag_item_value; // escaped
        add_lua_script("c2d:StartDragItem('" + escape(dragging_item_type) + "','" + dragging_item_value + "')");
    }
   
//    if(drag_item_type != "")
//    {
//        texture.onmousedown = function(event)
//        {
//            dragging_item_type = drag_item_type;
//            if (drag_item_value == "")
//                dragging_item_value = escape(texture.texture_src_fn)
//            else
//                dragging_item_value = drag_item_value; // escaped
//            add_lua_script("c2d:StartDragItem('" + escape(dragging_item_type) + "','" + dragging_item_value + "')");
//            return false;
//        }
//    }

    // old internal drag and drop
    //texture.onmouseup = function (event)
    //{
        //dragging_item_type = lib_drag_item_type;
        //add_lua_script("c2d:StopDragItem('"+escape(dragging_item_type)+"')");
        //dragging_item_type = "";
    //}    

    //if((lua_update_rect != "") || (lua_set_crop_point != ""))
    {
        // define texture crop rectangle with mouse (drawing a rect on texture)
        texture.onmousedown = function(event)
        {
            hidehintbox();
            blur_all_elements();

            if (texture.lua_set_crop_point != "")
                texture.picking_crop_by_point = true;

            if (texture.drag_item_type != "")
                texture.may_start_drag = true
                

            texture.picking_crop_by_point_x = event.offsetX;
            texture.picking_crop_by_point_y = event.offsetY;
            texture.mouse_downed_x = event.pageX;
            texture.mouse_downed_y = event.pageY;

// old way rect
//             texture.updating_rect_now = true;
//             texture.updating_rect_px = event.offsetX;
//             texture.updating_rect_py = event.offsetY;
//             texture.updating_rect_pxx = texture.updating_rect_px;
//             texture.updating_rect_pyy = texture.updating_rect_py;
            return false;
        }
        texture.onmousemove = function(event)
        {
            //texture.style.backgroundColor = "black";
            if ((Math.abs(texture.mouse_downed_x - event.pageX) > 4)
                || (Math.abs(texture.mouse_downed_y - event.pageY) > 4))
            {
                texture.picking_crop_by_point = false;

                if (texture.may_start_drag && (texture.drag_item_type != ""))
                {
                    // start drag
                    texture.may_start_drag = false;
                    texture.start_drag_now();
                    return false;
                }
            }
            
            
// old way rect
//             if(!texture.updating_rect_now) return;
//             texture.updating_rect_pxx = event.pageX;
//             texture.updating_rect_pyy = event.pageY;
//             var ctx=texture.getContext("2d");
//             ctx.clearRect(0, 0, texture.width, texture.height);
//             ctx.globalCompositeOperation = 'copy'; // set overwrite color mode
//             ctx.fillStyle = "rgba(255, 0, 255, 0.1)";
//             ctx.fillRect(0, 0, texture.width, texture.height);
//             ctx.fill();
//             ctx.globalCompositekOperation = 'source-over'; // set back the default draw mode
//             ctx.drawImage(texture.img_loader, texture.imgdrw_x, texture.imgdrw_y, texture.imgdrw_w, texture.imgdrw_h, 0, 0, texture.imgdrw_xx, texture.imgdrw_yy);
//             ctx.strokeStyle="#FF0000";
//             ctx.strokeRect(texture.updating_rect_px, texture.updating_rect_py, texture.updating_rect_pxx - texture.updating_rect_px, texture.updating_rect_pyy - texture.updating_rect_py);
        }

        texture.onmouseup = function (event)
        {
            texture.may_start_drag = false;
            if(!texture.picking_crop_by_point) return false;
            texture.picking_crop_by_point = false;
            
            if (Math.abs(texture.mouse_downed_x - event.pageX) > 4) return false;
            if (Math.abs(texture.mouse_downed_y - event.pageY) > 4) return false;

            // define crop point:
            if (texture.lua_set_crop_point != "") {
                var cx, cy;
                var txw = texture.crop_w;
                var txh = texture.crop_h;
                if ((txw == 0) || (txh == 0)) {
                    txw = texture.orig_width / texture.width;
                    txh = texture.orig_height / texture.height;
                }
                else {
                    txw /= texture.width;
                    txh /= texture.height;
                }
                cx = texture.picking_crop_by_point_x * txw + texture.crop_x;
                cy = texture.picking_crop_by_point_y * txh + texture.crop_y;
                cx *= texture.aspect_to_max_size;
                cy *= texture.aspect_to_max_size;
                var params = cx.toString() + "," + cy.toString();
                var lua_script = texture.lua_set_crop_point;
                lua_script = lua_script.replace(/~VALUE~/g, params);
                add_lua_script(lua_script);
            }

// old way rect:            

//             if(!texture.updating_rect_now) return;
//             texture.updating_rect_now = false;
//             
//             // redraw texture
//             var ctx=texture.getContext("2d");
//             ctx.drawImage(texture.img_loader, texture.imgdrw_x, texture.imgdrw_y, texture.imgdrw_w, texture.imgdrw_h, 0, 0, texture.imgdrw_xx, texture.imgdrw_yy);
//            
//             // calculate crop rectangle and send lua to change it
//             
//             var cx,cy,cxx,cyy;
//             var txw = texture.crop_w;
//             var txh = texture.crop_h;
//             if((txw==0) || (txh==0))
//             {
//                 txw = texture.orig_width / texture.width;
//                 txh = texture.orig_height / texture.height;
//             }
//             else
//             {
//                 txw /= texture.width;
//                 txh /= texture.height;
//             }
//             cx = texture.updating_rect_px   * txw + texture.crop_x;
//             cy = texture.updating_rect_py   * txh + texture.crop_y;
//             cxx = texture.updating_rect_pxx * txw + texture.crop_x;
//             cyy = texture.updating_rect_pyy * txh + texture.crop_y;
//             if(cx>cxx) {var cxc = cx; cx=cxx; cxx=cxc;}
//             if(cy>cyy) {var cyc = cy; cy=cyy; cyy=cyc;}
//             cxx = cxx - cx;
//             cyy = cyy - cy;
//             var params = cx.toString()+","+cy.toString()+","+cxx.toString()+","+cyy.toString();
//             var lua_script = texture.lua_update_rect;
//             lua_script = lua_script.replace(/~VALUE~/g, params);
//             add_lua_script(lua_script);            

//         texture.onmouseout = function(event)
//         {
//             texture.updating_rect_now = false;
//         }
// 
//         texture.blur = function(event)
//         {
//             texture.updating_rect_now = false;
//         }
        }
    }

    texture.onmouseover = function () {
        if (this.hint_text != "")
            showhintbox(this.hint_text, this, '', No);
        //this.style.backgroundColor = "black";
    }

    texture.onmouseout = function () {
        if (this.hint_text != "")
            hidehintbox();

        if (texture.may_start_drag && (texture.drag_item_type != "")) {
            // start drag
            texture.may_start_drag = false;
            texture.start_drag_now();
        }
        //this.style.backgroundColor = "white";
    }

    if (hint_text != "")
    {
        //texture.onmouseover = function(){showhintbox(hint_text, this, '', Yes)};
        texture.label.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };
    }

    if(end_with_new_line) add_new_line("", append_to_obj);
}

function hide_texture(obj_id, hide_img, hide_label)
{
    obj_id = document.getElementById(obj_id);
    if(hide_img) obj_id.style.display = "none";
    if(hide_label) obj_id.label.style.display = "none";
}

function show_texture(obj_id, show_img, show_label)
{
    obj_id = document.getElementById(obj_id);
    if(show_img) obj_id.style.display = "inline";
    if(show_label) obj_id.label.style.display = "inline";
}


// LUABOX

function request_update_luabox(wh)
{
    if(luaboxes[wh].update_script=="") return;
    
    if(luaboxes[wh].obj.parentNode.style.display == "none") return;
    //if(is_my_ctrl_hidden_now(luaboxes[wh].obj)) return; 

    var w = document.body.offsetWidth - 20;
    luaboxes[wh].obj.CM_Editor.getScrollerElement().style.width = w;
    luaboxes[wh].obj.CM_Editor.getScrollerElement().style.height = "100%";
    luaboxes[wh].obj.CM_Editor.refresh();

        if(luaboxes[wh].update_readonly != "")
        add_lua_script_update("c2d:EdyUpdateLuaBoxReadOnly('"+luaboxes[wh].obj_id+"', " + luaboxes[wh].update_readonly + ");");

     if(luaboxes[wh].obj.my_focus_store) return;

     add_lua_script_update("c2d:EdyUpdateLuaBox('"+luaboxes[wh].obj_id+"', " + luaboxes[wh].update_script + ");");
}

function update_luabox(luabox_id, new_value)
{
    new_value = unescape(new_value);
    var cm_editor_p = document.getElementById(luabox_id).CM_Editor;
    if(cm_editor_p.getValue() != new_value)
        cm_editor_p.setValue(new_value);
}

function update_luabox_readonly(luabox_id, new_value)
{
    var cm_editor_p = document.getElementById(luabox_id).CM_Editor;
    if(new_value=="false") new_value = false;
    cm_editor_p.setOption("readOnly",new_value)
}

function luabox_key_event(editor, event)
{
    var key_code = (event.which) ? event.which : event.keyCode;
    
    var luabox = document.getElementById(editor.c2d_luabox_id);
    if(event.type == "keyup") 
    {
            hidehintbox();
            var lua_onchange_script = luabox.lua_onchange;
            lua_onchange_script = lua_onchange_script.replace(/~VALUE~/g, "\""+escape(luabox.CM_Editor.getValue())+"\"");
            add_lua_script(lua_onchange_script);
    
        //editor.setValue(luabox.id);
    }
}

function luabox_on_focus(editor, event)
{
    document.getElementById(editor.c2d_luabox_id).my_focus_store = true;
}

function luabox_on_blur(editor, event)
{
    document.getElementById(editor.c2d_luabox_id).my_focus_store = false;
}

function add_luabox(obj_id, current_value, box_width, box_height, lua_onchange, update_script, hint_text, append_to_obj, end_with_new_line, do_read_only, lua_update_readonly)
{
    if(do_read_only==undefined) do_read_only = false;
    else if(do_read_only) do_read_only = "nocursor";
    else do_read_only = false;
    
    var luabox_div = document.createElement("div");
    document.getElementById(append_to_obj).appendChild(luabox_div);
    //luabox_div.style.lineHeight = "15px";
    //luabox_div.style.fontSize = "large";
    luabox_div.style.width = "100%";
    //luabox_div.style.height = "100%";
    luabox_div.id = obj_id + "_div";

    var luabox = document.createElement("textarea");

    luabox.id = obj_id;
    luabox.value = current_value;
    luabox.readonly = false;
//     luabox.style.width = "100px";
//     luabox.style.height = "300px";
    //luabox.style.lineHeight = "20px";
    //luabox.style.fontSize = "20px";

    luabox.my_focus_store = false;
    luabox.lua_onchange = lua_onchange;

    luabox_div.appendChild(luabox);

    //    /*if(hint_text!="") */luabox.onmouseover = function(){showhintbox("hint_text", this, '', Yes)};
    
    luabox.CM_Editor = CodeMirror.fromTextArea(luabox, {
        tabMode: "indent",
        tabSize: "2",
        matchBrackets: true,
        lineNumbers: true,
        theme: "lesser-dark",
        onKeyEvent: luabox_key_event,
        onFocus: luabox_on_focus,
        onBlur: luabox_on_blur,
        readOnly: do_read_only
    });
    
    //luabox.CM_Editor.setOption("readOnly", "nocursor");
    
    luabox.CM_Editor.c2d_luabox_id = obj_id;
    
//     luabox.CM_Editor.getScrollerElement().style.width = box_width;
//     luabox.CM_Editor.getScrollerElement().style.height = box_height;
//     luabox.CM_Editor.refresh();

    if(obj_id!="")
    {
        luaboxes[luaboxes_cnt] = new Object();
        luaboxes[luaboxes_cnt].obj_id = obj_id;
        luaboxes[luaboxes_cnt].obj = luabox;
        luaboxes[luaboxes_cnt].update_script = update_script;
        luaboxes[luaboxes_cnt].update_readonly = lua_update_readonly;
        luaboxes[luaboxes_cnt].CM_Editor = luabox.CM_Editor;
        luaboxes_cnt = luaboxes_cnt +1;
    }
    
    if(end_with_new_line) add_new_line("", append_to_obj);
}


// LISTBOX

function add_listbox(obj_id, lines_cnt, box_width, box_height, lua_onselect, get_selected_option_script,
    update_script, hint_text, bg_color, append_to_obj, end_with_new_line, lua_copy, lua_paste, lua_del, lua_enabled_script, lua_obj_check, lua_on_doubeclick, lua_update_colors)
{
    if (lua_on_doubeclick == undefined) lua_on_doubeclick = "";
    if (lua_update_colors == undefined) lua_update_colors = "";

    var listbox = document.createElement("select");

    listbox.id = obj_id;
    listbox.size = lines_cnt;
    listbox.style.width = box_width;
    listbox.style.height = box_height;
    listbox.style.backgroundColor = c2d_colors_unselected;
    listbox.style.color = c2d_colors_font1;
    listbox.style.borderColor = c2d_colors_border1;
    listbox.style.fontFamily = c2d_font;
    listbox.style.fontStyle = "normal";
    listbox.style.fontSize = c2d_font_size_normal;
    listbox.style.borderRadius = "4px"
    listbox.style.boxShadow = c2d_box_shadow;

    listbox.lua_onselect = lua_onselect;
    listbox.lua_on_doubeclick = lua_on_doubeclick;
    listbox.last_selected_on_click = -1;
    listbox.prev_selected_on_click = -1;
    listbox.allow_one_select_change = false;
    listbox.wanna_return_back_to_dropdown_list = false;
    listbox.hide_to_dropdown_list_now = false;
    listbox.style.boxShadow = c2d_box_shadow;

    listbox.my_focus_store = false;
//    listbox.onfocus = function() {this.my_focus_store = true;}
//    listbox.onblur = function() {this.my_focus_store = false;}
    
    listbox.do_auto_lines_cnt = (box_height == "auto");

    listbox.onmousedown = function() { return true; }
    listbox.onselectstart = function () { return true; }

    listbox.onfocus = function() 
    {
         this.my_focus_store = true; 
         this.style.backgroundColor = c2d_colors_selected;
//         if(this.size == 1) 
//         {
//             this.size = 9;
//             this.wanna_return_back_to_dropdown_list = true;
//             this.hide_to_dropdown_list_now = false;
//         }
    }
    listbox.onblur = function() 
    {
        this.my_focus_store = false; 
        this.style.backgroundColor = c2d_colors_unselected;
        if(this.wanna_return_back_to_dropdown_list)
        {
            this.size=1;
            this.wanna_return_back_to_dropdown_list = false;
        }
    }

    if (lua_enabled_script == undefined) lua_enabled_script = "";
    if (lua_obj_check == undefined) lua_obj_check = "";
    if(obj_id!="")
    {
        listboxes[listboxes_cnt] = new Object();
        listboxes[listboxes_cnt].obj_id = obj_id;
        listboxes[listboxes_cnt].obj = listbox;
        listboxes[listboxes_cnt].update_script = update_script;
        listboxes[listboxes_cnt].get_selected_option_script = get_selected_option_script;
        listboxes[listboxes_cnt].lua_enabled_script = lua_enabled_script;
        listboxes[listboxes_cnt].lua_obj_check = lua_obj_check;
        listboxes[listboxes_cnt].lua_update_colors = lua_update_colors;
        listboxes_cnt = listboxes_cnt + 1;
    }

    document.getElementById(append_to_obj).appendChild(listbox);

    if (hint_text != "") listbox.onmouseover = function () { showhintbox(hint_text, this, '', Yes) };

    if(lua_onselect != "")
    {
        listbox.onchange = function () { 
            // on select
            if (this.my_focus_store == false) return;
            if (this.length == 0) return;
            var lua_script = lua_onselect;
            lua_script = lua_script.replace(/~VALUE~/g, listbox.options.selectedIndex);
            add_lua_script(lua_script);
            hidehintbox();
            if(listbox.wanna_return_back_to_dropdown_list)
            {
                if(listbox.hide_to_dropdown_list_now)
                {
                    listbox.size=1;
                    listbox.wanna_return_back_to_dropdown_list = false;
                }
            }
        }
        listbox.onmouseup = function () 
        { 
            if (this.length == 0) return;
            if (listbox.size == 1)
            {
                listbox.size = 9;
                listbox.wanna_return_back_to_dropdown_list = true;
                listbox.hide_to_dropdown_list_now = false;
            }
            else
            {
                if (listbox.wanna_return_back_to_dropdown_list) {
                    listbox.hide_to_dropdown_list_now = true;
                }
            }
            listbox.prev_selected_on_click = listbox.last_selected_on_click;
            listbox.last_selected_on_click = listbox.options.selectedIndex;
        }
        listbox.ondblclick = function ()
        {
            if (this.length == 0) return;
            if (listbox.last_selected_on_click != listbox.options.selectedIndex)
                return;
            if (listbox.prev_selected_on_click != listbox.options.selectedIndex)
                return; // avoids bad double clicks on different listbox items
            add_lua_script(lua_on_doubeclick);
            hidehintbox();
        }
    }

    // lua copy and paste
    if(lua_copy == undefined) lua_copy = "";
    if(lua_paste == undefined) lua_paste = "";
    if(lua_del == undefined) lua_del = "";
    if((lua_copy != "") || (lua_paste != "") || (lua_del != ""))
    {
        listbox.onkeyup = function (evt) 
        { 
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            hidehintbox();
            if(evt.ctrlKey)
            {
                // ctrl+c copy
                if(charCode == 67) if(lua_copy != "") add_lua_script(lua_copy);
                // ctrl+v paste
                if(charCode == 86) if(lua_paste != "") 
                {
                    add_lua_script(lua_paste);
                    listbox.allow_one_select_change = true;
                }
            }
            else
            {
                // del
                if(charCode == 46)
                {
                    add_lua_script(lua_del);
                    listbox.allow_one_select_change = true;
                }
            }
        }
    }
    else
    {
        listbox.onkeyup = function (evt) 
        { 
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            hidehintbox();
            if(charCode == 13)
            {
            if(listbox.size == 1) 
            {
                listbox.size = 9;
                listbox.wanna_return_back_to_dropdown_list = true;
                listbox.hide_to_dropdown_list_now = false;
            }
            else
            {
                listbox.wanna_return_back_to_dropdown_list = false;
                listbox.size=1;
            }
            }
        }
    }


    if(end_with_new_line) add_new_line("", append_to_obj);
}

function request_update_listbox(wh)
{
    if (is_my_ctrl_hidden_now(listboxes[wh].obj)) return;

    if (listboxes[wh].lua_enabled_script != "")
        add_lua_script_update("c2d:EdyUpdateListBoxEnabled('" + listboxes[wh].obj_id + "', " + listboxes[wh].lua_enabled_script + ");");

    if (listboxes[wh].update_script != "")
    {
        //if(listboxes[wh].obj.my_focus_store) return;
        var sel_opt = listboxes[wh].get_selected_option_script;
        if (sel_opt == "") sel_opt = 0;

        var lua_script = "c2d:EdyUpdateListBox('" + listboxes[wh].obj_id + "', " + listboxes[wh].update_script + ", " + sel_opt + ");";
        if (listboxes[wh].lua_obj_check != "") {
            lua_script = "if(" + listboxes[wh].lua_obj_check + ") then " + lua_script + " end;"
        }
        add_lua_script_update(lua_script);
    }

    if (listboxes[wh].lua_update_colors != "")
    {
        var lua_script = "c2d:EdyUpdateListBoxColors('" + listboxes[wh].obj_id + "', " + listboxes[wh].lua_update_colors + ");";
        if (listboxes[wh].lua_obj_check != "") 
        {
            lua_script = "if(" + listboxes[wh].lua_obj_check + ") then " + lua_script + " end;"
        }
        add_lua_script_update(lua_script);
    }
}

function update_listbox(listbox_id, new_values, selected_index)
{
    var listbox = document.getElementById(listbox_id);
    var new_cnt = new_values.length;
    var old_cnt = listbox.options.length;
    for(var i=0; i<new_cnt; i++)
    {
        if(i>=old_cnt) 
        {
            var new_opt = new Option(unescape(new_values[i]), i.toString());
            //var new_opt = new Option("<IMG src = 'edit_object.png'>", i.toString());
            if(listbox.lua_onselect!="")
            {
                new_opt.onclick = function () {
                    hidehintbox();
                    var lua_script = listbox.lua_onselect;
                    lua_script = lua_script.replace(/~VALUE~/g, this.value);
                    add_lua_script(lua_script);
                }
            }
            listbox.add(new_opt); // add item
        }
        else listbox.options.item(i).text = unescape(new_values[i]); // change item title

    }
    // delete old options if the new_values contain less elements then are created in our listbox
    for(var i=old_cnt-1; i>=new_cnt; i--) listbox.options.remove(i);
    
    var lcnt = new_cnt; if(lcnt<2) lcnt=2; //if(lcnt>10) lcnt=10;
    if(listbox.do_auto_lines_cnt) listbox.size = lcnt;
    
    // select one option
    var chng = !listbox.my_focus_store;
    if(listbox.allow_one_select_change && (listbox.options.selectedIndex != selected_index))
    {
        chng = true;
        listbox.allow_one_select_change = false;
    }
    if(chng)
    {
        if ((selected_index >= 0) && (selected_index < new_cnt) && (listbox.options.selectedIndex != selected_index))
            listbox.options.selectedIndex = selected_index;
    }
}

function update_listbox_colors(listbox_id, new_values)
{
    var listbox = document.getElementById(listbox_id);
    var cnt = listbox.options.length;
    if (cnt>new_values.length) cnt = new_values.length;
    for(var i=0; i<cnt; i++)
    {
        if (new_values[i] != "")
            //listbox.options.item(i).text = unescape(new_values[i]);
            listbox.options.item(i).style.backgroundColor = unescape(new_values[i]);
        else
            listbox.options.item(i).style.backgroundColor = "transparent";
    }
}

// GRID
function add_grid(obj_id, update_script, hint_text, append_to_obj, end_with_new_line, row_width, lua_get_selected, 
            lua_to_select, ico_checked, lua_check, lua_check_one, ico_locked, lua_lock)
{
    if(row_width == undefined) row_width = 40;
    if(end_with_new_line == undefined) end_with_new_line = false;
    if(lua_get_selected == undefined) lua_get_selected = "";
    if(lua_to_select == undefined) lua_to_select = "";
    if(ico_checked == undefined) ico_checked = "";
    if(lua_check == undefined) lua_check = "";
    if(lua_check_one == undefined) lua_check_one = "";
    if(ico_locked == undefined) ico_locked = "";
    if(lua_lock == undefined) lua_lock = "";

   var grid = document.createElement("table");

    grid.id = obj_id;
//     grid.style.width = box_width;
//     grid.style.height = box_height;
//     grid.style.backgroundColor = bg_color;

    grid.my_focus_store = false;
    
    grid.m_rowsc = 0;
    grid.m_row_width = row_width;
    grid.m_lua_to_select = lua_to_select;
    grid.hint_text = hint_text;
    
    grid.style.border = "1px solid black";
    grid.cellPadding = 1;
    grid.cellSpacing = 0;
    grid.style.textAlign = "center";
    grid.style.fontFamily = c2d_font;
    grid.style.fontStyle = "normal";
    grid.style.fontSize = c2d_font_size_normal;
    grid.style.color = c2d_colors_font1;
    grid.style.backgroundColor = c2d_colors_bg1;
    grid.m_ico_checked = ico_checked;
    grid.m_ico_locked = ico_locked;
    grid.m_lua_check = lua_check;
    grid.m_lua_check_one = lua_check_one;
    grid.m_lua_lock = lua_lock;
    
    grid.onfocus = function() 
    {
        this.my_focus_store = true; 
        this.style.backgroundColor = c2d_colors_selected;
    }
    grid.onblur = function() 
    {
        this.my_focus_store = false; 
        this.style.backgroundColor = c2d_colors_unselected;
    }

    if(obj_id!="")
    {
        grids[grids_cnt] = new Object();
        grids[grids_cnt].obj_id = obj_id;
        grids[grids_cnt].obj = grid;
        grids[grids_cnt].update_script = update_script;
        grids[grids_cnt].lua_get_selected = lua_get_selected;
        grids_cnt = grids_cnt +1;
    }

    document.getElementById(append_to_obj).appendChild(grid);

    // header row
    var trr = document.createElement("tr");
    trr.id = grid.id+"_tr_head";
    grid.appendChild(trr);
    for(var i=0; i<5; i++)
    {
        var tdd = document.createElement("td");
        tdd.id = grid.id+"_td_head_"+i.toString();
        tdd.style.backgroundColor = c2d_colors_bg1;
        tdd.style.borderBottom = "3px solid grey";
        tdd.style.borderRight = "1px dotted grey";
        trr.appendChild(tdd);
    }

    if(end_with_new_line) add_new_line("", append_to_obj);
}

function request_update_grid(wh)
{
     if(grids[wh].update_script=="") return;
     if(is_my_ctrl_hidden_now(grids[wh].obj)) return; 
     //if(grids[wh].obj.my_focus_store) return;
     var gsel = grids[wh].lua_get_selected;
     if(gsel=="") gsel = "0";
     add_lua_script_update("c2d:EdyUpdateGrid('"+grids[wh].obj_id+"', " + grids[wh].update_script + " , " + gsel + ");");
}

function update_grid(grid_id, new_values, selected_index)
{
    var grid = document.getElementById(grid_id);

    var new_cnt = new_values.length / 5 - 1;
    var old_cnt = grid.m_rowsc;
    var wh = 0;
    var rcolor;

    // header row
    var trr = document.getElementById(grid.id+"_tr_head");
    for(var i=0; i<5; i++)
    {
        var tdd = document.getElementById(grid.id+"_td_head_"+i.toString());
        tdd.innerText = new_values[wh]; wh = wh+ 1;
        if (grid.hint_text != "") tdd.onmouseover = function () { showhintbox(grid.hint_text, this, '', Yes) };
        tdd.style.cursor = "default"
    }

    // rows
    var trr,tdd,val;
    for(var i=0; i<new_cnt; i++)
    {
        rcolor = c2d_colors_bg1;
        if(i>=old_cnt) 
        {
            trr = document.createElement("tr");
            trr.id = grid.id+"_tr_"+i.toString();
            grid.appendChild(trr);
        }
        for(var j=0; j<5; j++)
        {
            if(i>=old_cnt)
            {
                tdd = document.createElement("td");
                tdd.id = grid.id+"_td_"+i.toString()+"_"+j.toString();
                
                val = unescape(new_values[wh]);
                wh = wh+ 1;

                tdd.style.borderBottom = "1px solid grey";
                tdd.style.borderRight = "1px dotted grey";
                tdd.style.width = grid.m_row_width;
                
                tdd.m_lua_sel = grid.lua_to_select;
                tdd.m_wh_i = i.toString();
                
                tdd.style.cursor = "default"
                
                if(j==0)
                {
                    tdd.onmousedown = function () {
                                    hidehintbox();
                                    var lua_script;
                                    if(control_key_is_down) lua_script = grid.m_lua_check_one;
                                    else lua_script = grid.m_lua_check;
                                    lua_script = lua_script.replace(/~VALUE~/g, this.m_wh_i);
                                    add_lua_script(lua_script);
                                }
                    tdd.onmouseover = function () {
                                    if (grid.hint_text != "") showhintbox(grid.hint_text, this, '', Yes);
                                    if(left_mouse_is_down || control_key_is_down)
                                    {
                                        var lua_script = grid.m_lua_check;
                                        lua_script = lua_script.replace(/~VALUE~/g, this.m_wh_i);
                                        add_lua_script(lua_script);
                                    }
                                }
                }
                else if(j==1)
                {
                    tdd.onmousedown = function () {
                                    hidehintbox();
                                    var lua_script = grid.m_lua_lock;
                                    lua_script = lua_script.replace(/~VALUE~/g, this.m_wh_i);
                                    add_lua_script(lua_script);
                                }
                    tdd.onmouseover = function (event) {
                                    if (grid.hint_text != "") showhintbox(grid.hint_text, this, '', Yes);
                                    if(left_mouse_is_down)
                                    {
                                        var lua_script = grid.m_lua_lock;
                                        lua_script = lua_script.replace(/~VALUE~/g, this.m_wh_i);
                                        add_lua_script(lua_script);
                                    }
                                }
                }
                else
                {
                    if(grid.hint_text!="") 
                        tdd.onmouseover = function () { showhintbox(grid.hint_text, this, '', Yes) };
                    
                    tdd.onmousedown = function () {
                                    hidehintbox();
                                    var lua_script = grid.m_lua_to_select;
                                    lua_script = lua_script.replace(/~VALUE~/g, this.m_wh_i);
                                    add_lua_script(lua_script);
                                }
                }
                if(j<=1) 
                {
                    tdd.style.backgroundPosition = "center"
                    tdd.style.backgroundRepeat = "no-repeat"
                }
                trr.appendChild(tdd);
            }
            else
            {
                tdd = document.getElementById(grid.id+"_td_"+i.toString()+"_"+j.toString());
                val = unescape(new_values[wh]);
                wh = wh+ 1;
            }
            if(j==0)
            {
                tdd.innerText = "";
                if(val == "true") tdd.style.backgroundImage = "url('"+grid.m_ico_checked+"')";
                else tdd.style.backgroundImage = "";
            }
            else if(j==1)
            {
                tdd.innerText = "";
                if(val == "true") tdd.style.backgroundImage = "url('"+grid.m_ico_locked+"')";
                else tdd.style.backgroundImage = "";
            }
            else
            {
                tdd.innerText = val;
            }
            if(j==3) if(val == 1) rcolor = c2d_colors_bg2;
            if(j==2) 
            {
                if(val == 0) 
                {
                    tdd.style.border = "1px solid #44AA55";
                    tdd.style.borderBottom = "1px solid #44AA55";
                }
                else
                {
                    tdd.style.border = "none";
                    tdd.style.borderBottom = "1px solid grey";
                    tdd.style.borderRight = "1px dotted grey";
                }
            }
        }
        
        if(i==selected_index) rcolor = c2d_colors_selected;
        
        for(var j=0; j<5; j++)
            document.getElementById(grid.id+"_td_"+i.toString()+"_"+j.toString()).style.backgroundColor = rcolor;
    }
    
    for(var i=new_cnt; i<old_cnt; i++)
    {
        var trr = document.getElementById(grid.id+"_tr_"+i.toString());
        for(var j=0; j<4; j++)
        {
            var tdd = document.getElementById(grid.id+"_td_"+i.toString()+"_"+j.toString());
            trr.removeChild( tdd );
            delete tdd;
        }
        grid.removeChild(trr);
        delete trr;
    }
    
    grid.m_rowsc = new_cnt;
}
// PANEL

function add_table(obj_id, table_width, table_height, margin, border, cell_padding, cell_spacing, bg_color, hint_text, append_to_obj, end_with_new_line)
{
    var table = document.createElement("table");
    table.id = obj_id;
    table.style.width = table_width;
    table.style.height = table_height;
    table.style.margin = margin
    table.style.border = border;
    table.cellPadding = cell_padding;
    table.cellSpacing = cell_spacing;
    table.style.backgroundColor = bg_color;
    table.style.fontSize = "inherit";
    document.getElementById(append_to_obj).appendChild(table);
    if(end_with_new_line) add_new_line("", append_to_obj);
}

function add_table_tr(obj_id, tr_height, v_align, bg_color, hint_text, append_to_obj)
{
    var tr = document.createElement("tr");
    tr.id = obj_id;
    tr.style.height = tr_height;
    tr.vAlign = v_align;
    tr.style.backgroundColor = bg_color;
    document.getElementById(append_to_obj).appendChild(tr);
   
}

function add_table_td(obj_id, width, height, col_span, row_span, hint_text, border, bg_color, append_to_obj)
{
    var my_td = document.createElement("td");

    my_td.id = obj_id;
    my_td.style.width = width;
    my_td.style.height = height;
    if(col_span!="") my_td.colSpan = col_span;
    if(row_span!="") my_td.rowSpan = row_span;
    my_td.style.backgroundColor = bg_color;
    my_td.style.border = border;

    document.getElementById(append_to_obj).appendChild(my_td);
}

// SOUND SET

function add_soundset(obj_id, soundset_obj, append_to_obj, undo_object_name, undo_script, undo_start_script, undo_end_script, script_list_enabled)
{
    if (append_to_obj == undefined)
        append_to_obj = block;

    var script_set = "";
    var script_set2 = "";
    var script_get = "";
    var hint = "";
    var script_enabled = "(" + soundset_obj + "~=nil)";
    var script_undo = "";

    if (script_list_enabled == undefined)
        script_list_enabled = "";

    if (script_list_enabled != "")
        script_enabled = "(" + script_list_enabled + ") and " + script_enabled;


    if (undo_object_name == undefined) undo_object_name = "";
    if (undo_script == undefined) undo_script = "";
    if (undo_start_script == undefined) undo_start_script = "";
    if (undo_end_script == undefined) undo_end_script = "";

    function undo_script_make(undo_string, undo_script) {
        if (undo_script == "") return "";
        var full_string = undo_object_name + " - " + undo_string;
        var ret = undo_script.replace(/~VALUE~/g, full_string);
        if (ret == "") return ret;
        if (ret.charAt(ret.length - 1) != ';') ret = ret + ';';
        return ret;
    }

    add_label(obj_id + "__label1", " sound set name:", "", "", append_to_obj, Yes, "", "icon3_sound.png", script_enabled);


    script_set = soundset_obj + ":SetName(c2d:UnEscapeString(~VALUE~))";
    script_get = soundset_obj + ":GetName()";
    script_undo = undo_script_make("sound set - name", undo_script);

    add_stringbox(obj_id + "__name", "", script_undo + script_set, script_get, "input sound set name", append_to_obj, Yes, "100%", "", 32, script_enabled, script_enabled);

    add_new_line(obj_id + "__br1", append_to_obj);

    add_label(obj_id + "__label1b", "assigned sounds:", "", "", append_to_obj, Yes, "", "", script_enabled);

    script_set = "if not c2d:AutoShowAudioLib() then " + soundset_obj + ":AssignFromAudioLib() end"
    hint = "assign currently selected sounds in texture library to this object. Press F3 to open sound library window.";
    script_undo = undo_script_make("sound set - assign sound file(s)", undo_script);
    add_button(obj_id + "__assign", " assign selected sounds", "180", 22, script_undo + script_set, "", hint, append_to_obj, No, script_enabled, "", "icon_assign.png", "");

    var script_rem = script_undo + soundset_obj + ":RemoveSelectedSound()";
    add_button(obj_id + "__del", "", "", 22, script_rem, "", "click to delete selected sound from list<br>or click on the sound in the list and press Del.", append_to_obj, Yes, script_enabled, "", "icon_del.png", "");

        
    script_set = soundset_obj + ":SelectSound(~VALUE~); c2d:PlaySoundFilePreview("+soundset_obj+":GetSelectedSoundFileName())";
    var script_get = soundset_obj+":GetSelectedSound()";
    var script_get2 = soundset_obj + ":GetSoundsListArray()";
    script_undo = undo_script_make("sound set - remove sound file", undo_script);
    hint = "list of sound files in this sound set<br>one randomly chosen sound will be played for the action<br>select sound and press Del to remove it from sound set";
    add_listbox(obj_id + "__list", 5, "100%", "", script_set, script_get, script_get2, hint, "", append_to_obj, Yes, "", "", script_rem, script_enabled, script_enabled);

    add_new_line(obj_id + "__br2", append_to_obj);

    add_label(obj_id + "__label2", "pitch change", "", "", append_to_obj, Yes, "", "", script_enabled);

    script_undo = undo_script_make("sound set - pitch change", undo_script);

    script_set = script_undo + soundset_obj + ":SetPitchChange(0)";
    script_get = soundset_obj+":GetPitchChange()";
    add_radio(obj_id + "__pitch1", obj_id + "pitch", "none", 0, script_set, script_get, "", append_to_obj, Yes, script_enabled, script_enabled);
    
    script_set = script_undo + soundset_obj + ":SetPitchChange(1)";
    script_get = soundset_obj+":GetPitchChange()";
    add_radio(obj_id + "__pitch2", obj_id + "pitch", "standard", 1, script_set, script_get, "", append_to_obj, Yes, script_enabled, script_enabled);

    script_set = script_undo + soundset_obj + ":SetPitchChange(2)";
    script_get = soundset_obj+":GetPitchChange()";
    add_radio(obj_id + "__pitch3", obj_id + "pitch", "set range (+-%):", 2, script_set, script_get, "", append_to_obj, Yes, script_enabled, script_enabled);

    add_label(obj_id + "__label3", "", "", "", append_to_obj, No, 8, "", script_enabled);

    script_undo = undo_script_make("sound set - pitch range", undo_script);
    script_set = script_undo + soundset_obj + ":SetCustomPitch( IntervalF(~VALUE~*0.01+1, " + soundset_obj + ":GetCustomPitch().mMaxValue ) )";
    script_get = "("+soundset_obj+":GetCustomPitch().mMinValue-1)*100";
    add_slider(obj_id + "__pitch_range1", 0, -10, 10, 0.1, script_set, script_get, "", append_to_obj, No, 60, script_enabled, script_enabled);

    add_label(obj_id + "__label4", "", "", "", append_to_obj, No, 8, "");
    add_label(obj_id + "__label5", " ~ ", "", "", append_to_obj, No, "", "", script_enabled);
    add_label(obj_id + "__label6", "", "", "", append_to_obj, No, 8, "");
    
    script_set = script_undo + soundset_obj + ":SetCustomPitch( IntervalF(" + soundset_obj + ":GetCustomPitch().mMinValue, ~VALUE~*0.01+1 ) )";
    script_get = "("+soundset_obj+":GetCustomPitch().mMaxValue-1)*100";
    add_slider(obj_id + "__pitch_range2", 0, -10, 10, 0.1, script_set, script_get, "", append_to_obj, Yes, 60, script_enabled, script_enabled);

    add_new_line(obj_id + "__br3", append_to_obj);

    script_set = script_undo + soundset_obj + ":SetOverlapLoopStart(true)";
    script_set2 = script_undo + soundset_obj + ":SetOverlapLoopStart(false)";
    script_get = soundset_obj + ":GetOverlapLoopStart()";
    add_checkbox(obj_id + "__over_start", "overlap loop start", No, script_set, script_set2, script_get, "if checked then the start sound will start playing together with middle loop sound", append_to_obj, Yes, script_enabled);

    script_set = script_undo + soundset_obj + ":SetOverlapLoopEnd(true)";
    script_set2 = script_undo + soundset_obj + ":SetOverlapLoopEnd(false)";
    script_get = soundset_obj + ":GetOverlapLoopEnd()";
    add_checkbox(obj_id + "__over_end", "overlap loop end", No, script_set, script_set2, script_get, "if checked then the end sound will start playing together with middle loop sound", append_to_obj, Yes, script_enabled);

    add_new_line(obj_id + "__br4", append_to_obj);
    add_label(obj_id + "__label7", "max sounds per second ", "", "", append_to_obj, No, "", "", script_enabled);

    script_undo = undo_script_make("sound set - sounds per second", undo_script);
    script_set = script_undo + soundset_obj + ":SetMinDelay( 1 / ~VALUE~);";
    script_get = " 1 / " + soundset_obj + ":GetMinDelay()";
    var script_wheel_start = undo_script_make("sound set - sounds per second", undo_start_script);
    var script_wheel_end = undo_script_make("sound set - sounds per second", undo_end_script);
    hint = "limit triggering the sounds with this to be played up to specified times per second";
    add_number(obj_id + "__sounds_per_sec", 20, 1, 30, 1, Yes, script_set, script_get, hint, append_to_obj, Yes, 50, "", script_wheel_start, script_wheel_end, script_enabled);

    add_new_line(obj_id + "__br5", append_to_obj);

    script_set = "c2d:PlaySoundPreview(" + soundset_obj + ")";
    hint = "click more times to preview playng sounds by this sound set<br>random sound is played with defined settings.";
    add_button(obj_id + "__preview", " preview sound set", "100%", 22, script_set, "", hint, append_to_obj, Yes, script_enabled, "", "icon3_sound.png", "");
}

function add_soundset_list(obj_id, soundsetlist_obj, append_to_obj, undo_object_name, undo_script, undo_start_script, undo_end_script, lua_enabled_script)
{
    var script_sel = "";
    var script_get = "";
    var script_set = "";
    var script_copy = "";
    var script_paste = "";
    var script_copy_all = "";
    var script_paste_all = "";
    var script_del = "";
    var script_undo = "";
    var hint = "";
    var script_enabled = "(" + soundsetlist_obj + ":GetSelected()~=nil)";
    if (lua_enabled_script == undefined) lua_enabled_script = "";
    if (lua_enabled_script != "")
        lua_enabled_script = "(" + lua_enabled_script + ")";
    if (lua_enabled_script != "")
        script_enabled = lua_enabled_script + " and " + script_enabled;
    
    lua_enabled_script_paste = "(c2d:EdyCopySoundSetSaved())";
    lua_enabled_script_paste2 = "(c2d:EdyCopySoundSetListSaved())";
    if (lua_enabled_script != "") {
        lua_enabled_script_paste = lua_enabled_script + " and " + lua_enabled_script_paste;
        lua_enabled_script_paste2 = lua_enabled_script + " and " + lua_enabled_script_paste2;
    }

    hint = "add sound set";
    script_set = soundsetlist_obj + ":Insert()";

    var name_string_box = obj_id + "__soundset__name";

    if (undo_object_name == undefined) undo_object_name = "";
    if (undo_script == undefined) undo_script = "";
    if (undo_start_script == undefined) undo_start_script = "";
    if (undo_end_script == undefined) undo_end_script = "";

    function undo_script_make(undo_string)
    {
        if (undo_script == "") return "";
        var full_string = undo_object_name + " - " + undo_string;
        var ret = undo_script.replace(/~VALUE~/g, full_string);
        if (ret == "") return ret;
        if (ret.charAt(ret.length - 1) != ';') ret = ret + ';';
        return ret;
    }
    
    var jscript_click = "enable_stringbox('" + name_string_box + "'); focus_element('" + name_string_box + "'); document.getElementById('" + name_string_box + "').value = '';"


    script_undo = undo_script_make("sound set list - add sound set");
    add_button(obj_id + "__add", "", "", 24, script_undo + script_set, "", hint, append_to_obj, No, lua_enabled_script, jscript_click, "icon_add.png", "");

    hint = "click to delete selected sound set<br>or select sound set in list below and press Del";
    script_set = soundsetlist_obj + ":DeleteSelected()";
    script_undo = undo_script_make("sound set list - delete sound set");
    add_button(obj_id + "__del", "", "", 24, script_undo + script_set, "", hint, append_to_obj, No, script_enabled, "", "icon_del.png", "");

    add_label(obj_id + "__label1a", "", "", "", append_to_obj, No, "7", "", script_enabled);

    hint = "click to copy selected sound set<br>or select sound set in list below and press Ctrl+C";
    script_copy = "c2d:EdyCopySoundSet(" + soundsetlist_obj + ":GetSelected());";
    add_button(obj_id + "__copy", "", "", 24, script_copy, "", hint, append_to_obj, No, script_enabled, "", "icon_copy.png", "");

    hint = "click to paste sound set as new<br>or click on the sound set list below and press Ctrl+V";
    script_paste = "c2d:EdyPasteSoundSet(" + soundsetlist_obj + ");";
    script_undo = undo_script_make("sound set list - paste sound set");
    add_button(obj_id + "__paste", "", "", 24, script_undo + script_paste, "", hint, append_to_obj, No, lua_enabled_script_paste, "", "icon_paste.png", "");

    add_label(obj_id + "__label1b", "", "", "", append_to_obj, No, "7", "", script_enabled);

    hint = "copy whole this sound set list";
    script_copy_all = "c2d:EdyCopySoundSetList(" + soundsetlist_obj + ");";
    add_button(obj_id + "__copy2", "", "", 24, script_copy_all, "", hint, append_to_obj, No, script_enabled + " and " + soundsetlist_obj + ":GetCount()>0", "", "icon_copy_more.png", "");

    script_undo = undo_script_make("sound set list - paste whole sound set list");
    hint = "paste sound set list<br>replaces this list with the coppied list";
    script_paste_all = "c2d:EdyPasteSoundSetList(" + soundsetlist_obj + ");";
    add_button(obj_id + "__paste2", "", "", 24, script_undo + script_paste_all, "", hint, append_to_obj, No, lua_enabled_script_paste2, "", "icon_paste_more.png", "");

    script_sel = soundsetlist_obj + ":Select(~VALUE~)";
    script_get = soundsetlist_obj + ":GetSelectedIndex()";
    script_set = soundsetlist_obj + ":GetSoundSetsListArray()";
    script_undo = undo_script_make("sound set list - delete sound set");
    script_del = script_undo + soundsetlist_obj + ":DeleteSelected()";
    add_listbox(obj_id + "__list", 2, "100%", "", script_sel, script_get, script_set, "list of sound sets", "", append_to_obj, Yes, script_copy, script_paste, script_del, script_enabled, lua_enabled_script);

    add_new_line(obj_id + "__br1", append_to_obj);

    add_label(obj_id + "__label1", "selected sound set:", "", "", append_to_obj, Yes, "", "", script_enabled);

    add_new_line(obj_id + "__br2", append_to_obj);

    var sset_obj = soundsetlist_obj + ":GetSelected()";
    add_soundset(obj_id + "__soundset", sset_obj, append_to_obj, undo_object_name, undo_script, undo_start_script, undo_end_script, script_enabled)

}