


function C2DFileLib(name, dir_listbox_id, dir_listbox_parent_id, items_parent_id, files_path, file_drag_type,
    dbl_click_item_script, item_buttons_on, item_button_label, item_button_script, item_button_hint, item_button_icon, select_item_script,
    scroll_win_id, item_bg_img) {


    this.set_path = function (f_path) {
        this.files_path = f_path;
        this.files_path_use = "..\\"+f_path+"\\";
    }
    this.set_path(files_path);

    this.name = name;
    this.item = name+"_item"
    this.dir_listbox_id = dir_listbox_id;
    this.dir_listbox_parent_id = dir_listbox_parent_id;
    this.items_parent_id = items_parent_id;
    this.file_drag_type = file_drag_type;
    this.dbl_click_item_script = dbl_click_item_script;
    this.item_buttons_on = item_buttons_on;
    this.item_button_label = item_button_label;
    this.item_button_script = item_button_script;
    this.item_button_hint = item_button_hint;
    this.item_button_icon = item_button_icon;
    this.select_item_script = select_item_script;
    this.scroll_win_id = scroll_win_id;
    this.item_bg_img = item_bg_img;
    

    this.dirs = new Array();
    this.files = new Array();
    this.dir_selected = 0;
    this.file_view = 0;
    this.file_selected = "";
    this.file_selected_color = c2d_colors_selected;
    this.file_unselected_color = "#111111";//c2d_colors_unselected;
    this.dir_selected_before_reload = 0;
    this.file_selected_before_reload = "";


    // create listbox for directories:    
    var listbox = document.createElement("select");
    listbox.id = dir_listbox_id;
    listbox.size = 2;
    listbox.style.backgroundColor = "#CCDDCC"
    listbox.style.width = "100%";
    listbox.style.height = "100%";
    document.getElementById(this.dir_listbox_parent_id).appendChild(listbox);
    listbox.onkeyup = function () {
        this.select_dir(listbox.selectedIndex);
    }



    this.cleanup = function() {
        document.getElementById(this.dir_listbox_id).length = 0;
        for (i = this.files.length - 1; i >= 0; i--) {
            del_texture(this.item + i);
            del_label(this.item + "_lab" + i);
            del_button(this.item + "_load_btn" + i);
            var elem = document.getElementById(this.item + "_div" + i);
            if (elem != undefined) delete elem.parentNode.removeChild(elem);
        }
        document.getElementById(this.items_parent_id).onselectstart = function () { return false; }

        this.dir_selected_before_reload = this.dir_selected;
        this.file_selected_before_reload = this.file_selected;
        this.dirs.length = 0;
        this.files.length = 0;
        this.dir_selected = 0; // after reload we select the same dir
        this.file_selected = "";
    }

    this.add_dir = function(dir_name, dir, files_start_index, files_count) {
        dir_name = unescape(dir_name);
        if (dir_name == "") dir_name = "[root]";
        var l = this.dirs.length;
        this.dirs[l] = new Object();
        this.dirs[l].dir_name = dir_name;
        this.dirs[l].dir = dir;
        this.dirs[l].files_start_index = files_start_index;
        this.dirs[l].files_count = files_count;

        var opt = new Option(dir_name, dir);
        opt.onclick = function () { this.select_dir(l); }
        document.getElementById(this.dir_listbox_id).add(opt);
    }

    this.add_file_decal = function(file_name, decal_img)
    {
        file_name = unescape(file_name);
        decal_img = unescape(decal_img);
        var l = this.files.length;
        for(i=0; i<l; i++)
        {
            if(this.files[i].file_name == file_name)
            {
                this.files[i].tex_decal.src = decal_img;
                this.files[i].tex_decal.style.display = 'inline';
                return;
            }
        }
    }

    this.add_file = function(file_name, img_fn, dir_index) {
        img_fn = unescape(img_fn);
        file_name = unescape(file_name);
        var l = this.files.length;
        this.files[l] = new Object();
        this.files[l].file_name = file_name;
        this.files[l].img_fn = img_fn;
        this.files[l].dir_index = dir_index;

        var texdiv = document.createElement("table");
        texdiv.id = this.item + "_div" + l;
        document.getElementById(this.items_parent_id).appendChild(texdiv);

        texdiv.cellPadding = 3;
        texdiv.cellSpacing = 0;
        texdiv.style.overflow = "visible";
        texdiv.style.width = "70px";
        texdiv.style.height = "70px";
        texdiv.style.textAlign = "center";
        texdiv.style.verticalAlign = "middle";
        texdiv.style.display = "none";
        texdiv.style.border = "0 solid black";
        texdiv.style.margin = "0px";
        texdiv.style.marginBottom = "6px"
        texdiv.tabIndex = 0; // so the tabs are selectable
        texdiv.c2dlib = this;

        texdiv.onmousedown = function () {
            //texdiv.focus();
            texdiv.c2dlib.request_select_file(img_fn);
            // old internal drag and drop:
            //dragging_item_type = this.item + "_texture";
            //dragging_item_value = escape(img_fn);
            //add_lua_script("c2d:StartDragItem('"+escape(dragging_item_type)+"','"+dragging_item_value+"');");
        }

        var texdivtr = document.createElement("tr");
        texdiv.appendChild(texdivtr);

        var texdivtd = document.createElement("td");
        texdivtd.id = this.item + "_divtd" + l;
        texdivtr.appendChild(texdivtd);

        texdiv.onmouseover = function () { window.getSelection().removeAllRanges(); }
        texdiv.onselectstart = function () { return false; }
        texdivtr.onselectstart = function () { return false; }
        texdivtd.onselectstart = function () { return false; }

        // this little hack with '?' and getTime avoids using the images cached in browser and loads image every time instead
        var hint = "";//img_fn + "<br> <hr><img src = \""+this.files_path_use+"+escape(img_fn)+ "?" + (new Date()).getTime() +"\" onload = \"fix_hintbox_position()\" style=\"border:1px dotted black\"> ";

        var pre_siz = 100;
        if (this.file_view == 0) { pre_siz = 100; }
        if (this.file_view == 1) { pre_siz = 256; }

        add_texture(this.item + "_texture" + l, this.files_path_use + escape(img_fn), 256, 256, "", hint, this.item + "_divtd" + l, Yes, "none", Yes, "", "", file_drag_type, escape(img_fn));

        tex_decal = document.createElement('img');
        tex_decal.style.marginTop = -100;
        tex_decal.style.display = 'none';
        texdivtd.appendChild(tex_decal);

        tex_decal.onmousedown = function (event) { tex.onmousedown(event); }
        tex_decal.onmouseup = function (event) { tex.onmouseup(event); }
        tex_decal.onmousemove = function (event) { tex.onmousemove(event); }
        tex_decal.onmouseover = function (event) { tex.onmouseover(event); }
        tex_decal.onmouseout = function (event) { tex.onmouseout(event); }
        tex_decal.onmouseleave = function (event) { tex.onmouseleave(event); }
        tex_decal.ondblclick = function (event) { tex.ondblclick(event); }
        this.files[l].tex_decal = tex_decal;
        this.files[l].div = texdivtd;


        var label_str = unescape(file_name);
        label_str = label_str.substr(0, label_str.lastIndexOf('.'));

        add_textbox(this.item + "_label" + l, label_str, "", "100%", "", "", "", this.item + "_divtd" + l, No);
        //add_label(this.item + "_label" + l, label_str, "", "", this.item + "_divtd" + l, No, pre_siz);
        var tex_label = document.getElementById(this.item + "_label" + l);
        tex_label.style.fontFamily = c2d_font;
        tex_label.style.fontStyle = "normal";
        tex_label.style.fontSize = c2d_font_size_normal;
        if(label_str.substr(0,10) == "Prototype ")
            tex_label.style.color = "#FFFF88";
        else tex_label.style.color = "white";
        tex_label.style.textAlign = "center";
        tex_label.style.border = "none";
        tex_label.style.resize = "none";
        tex_label.style.overflow = "hidden";
        tex_label.style.backgroundColor = "transparent";
        tex_label.readOnly = true;
        tex_label.onfocus = "";
        tex_label.onblur = "";
        tex_label.rows = "2";

        var tex = document.getElementById(this.item + "_texture" + l);
        tex.tabIndex = 0;
        tex.c2dlib = this;

        if (this.item_bg_img != "")
            tex.style.backgroundImage = this.item_bg_img;

        texdivtr.tabIndex = 0;
        texdivtd.tabIndex = 0;
        if (this.dbl_click_item_script != "") {
            var fn = img_fn;
            if (this.files_path != "")
                fn = this.files_path + "\\" + fn;
            tex.ondblclick = function () {
                add_lua_script(tex.c2dlib.dbl_click_item_script.replace(/~VALUE~/g, escape(fn)));
                }
        }
        if (this.item_buttons_on) {

            var fn = img_fn;
            if (this.files_path != "")
                fn = this.files_path + "\\" + fn;

            add_button(this.item + "_load_btn" + l, this.item_button_label, "", "",
                this.item_button_script.replace(/~VALUE~/g, escape(fn)),
                "", this.item_button_hint, this.item + "_divtd" + l, No, "", "", this.item_button_icon, "", "");
            hide_button(this.item + "_load_btn" + l);
        }

        this.files[l].texdiv = texdiv;
        this.files[l].tex = tex;
        this.files[l].tex_label = tex_label;

    }

    this.select_dir = function(wh_dir) {
        if (this.dirs.length <= 0) return;

        var fst = this.dirs[this.dir_selected].files_start_index;
        var fend = fst + this.dirs[this.dir_selected].files_count;
        for (i = fst; i < fend; i++)
            document.getElementById(this.item + "_div" + i).style.display = "none";

        if (wh_dir >= this.dirs.length) wh_dir = this.dirs.length - 1;
        if (wh_dir < 0) wh_dir = 0;
        this.dir_selected = wh_dir;


        var pre_siz = 100;
        if (this.file_view == 0) { pre_siz = 100; }
        if (this.file_view == 1) { pre_siz = 256; }

        var fst = this.dirs[this.dir_selected].files_start_index;
        var fend = fst + this.dirs[this.dir_selected].files_count;
        var i;
        for (i = fst; i < fend; i++) {
            var divv = document.getElementById(this.item + "_div" + i.toString());
            //if (divv == undefined) continue;
            divv.style.display = "inline";
            divv.style.backgroundColor = this.c2d_colors_unselected;

            if (this.files[i].img_fn == this.file_selected)
                divv.style.backgroundColor = this.file_selected_color;
            else
                divv.style.backgroundColor = this.file_unselected_color;

            this.files[i].tex.style.width = pre_siz;
            this.files[i].tex.style.height = pre_siz;
            this.files[i].tex_label.style.width = pre_siz;
        }
    }

    this.request_select_file = function (tex_fn) {
        add_lua_script(this.select_item_script.replace( /~VALUE~/g, escape(tex_fn) ));
    }

    this.select_file = function (tex_fn) {
        tex_fn = unescape(tex_fn);
        this.file_selected = tex_fn;
        var scroll_to_obj = false;
        if (this.dirs.length <= 0) return;
        var fst = this.dirs[this.dir_selected].files_start_index;
        var fend = fst + this.dirs[this.dir_selected].files_count;
        for (i = fst; i < fend; i++) {
            var obj = document.getElementById(this.item + "_div" + i);
            if (this.files[i].img_fn == this.file_selected) {
                obj.style.backgroundColor = this.file_selected_color;
                if (!scroll_to_obj) scroll_to_obj = obj;
                if(this.item_buttons_on) show_button(this.item + "_load_btn" + i);
            }
            else {
                obj.style.backgroundColor = this.file_unselected_color;
                if (this.item_buttons_on) hide_button(this.item + "_load_btn" + i);
            }
        }

        if (scroll_to_obj) {
            var win_div = document.getElementById(this.scroll_win_id);
            if (win_div) {
                if (win_div.scrollTop + win_div.clientHeight < scroll_to_obj.offsetTop + scroll_to_obj.clientHeight - win_div.offsetTop)
                    win_div.scrollTop = scroll_to_obj.offsetTop - win_div.offsetTop - win_div.clientHeight + scroll_to_obj.clientHeight;

                if (win_div.scrollTop > scroll_to_obj.offsetTop - win_div.offsetTop)
                    win_div.scrollTop = scroll_to_obj.offsetTop - win_div.offsetTop;
            }
        }
    }

    this.update_finish = function () {
        this.select_dir(this.dir_selected_before_reload);
        this.select_file(this.file_selected_before_reload);
    }

    this.set_file_view = function (file_view) {
        this.file_view = file_view;
        var i = 0;
        var btn = document.getElementById(this.name + "_file_view_btn" + i);
        while(btn)
        {
            btn.onmouseover = function () { }
            btn.onmouseout = function () { }
            btn.style.background = "";
            if (i == this.file_view) btn.style.backgroundColor = "#FFFFFF";
            else btn.style.backgroundColor = "#666666";

            i = i + 1;
            btn = document.getElementById(this.name + "_file_view_btn" + i);
        }
        this.select_dir(this.dir_selected);
        this.select_file(this.file_selected);
    }


}

