
if not bpmenu then bpmenu = {} end
if not bpmenu.bp_adding_eff then bpmenu.bp_adding_eff = {} end

-- Update the blueprint menu
function bpmenu.update()
  if scene:GetAnyControllersWereAdded() then
    local added = scene:GetAddedControllers()
    for i,id in pairs(added) do
      if c2d_settings.all_blueprints_for_all_controllers then
        scene:LoadAllBlueprintsToController(scene:GetControllerByID(id))
      else
        bpmenu.add_basic_blueprints( scene:GetControllerByID(id))
      end
    end
  end
end

-- Add the default blueprints to the blueprint menu
function bpmenu.add_basic_blueprints(controller)
  if controller then 
    controller:AddBlueprintToMenuNoEffect("1T Graphite", No)
    controller:AddBlueprintToMenuNoEffect("1T Ice", No)
    controller:AddBlueprintToMenuNoEffect("1T Metals", No)
    controller:AddBlueprintToMenuNoEffect("1T Sandstone", No)
    controller:AddBlueprintToMenuNoEffect("Bomb", No)
    controller:AddBlueprintToMenuNoEffect("Tool Grappling Hook", No)
    controller:AddBlueprintToMenuNoEffect("Pioneer Test Dummy", No)
    controller:AddBlueprintToMenuNoEffect("Pioneer Imperatus", No)
    controller:AddBlueprintToMenuNoEffect("Pioneer Pink Horror", No)
    controller:AddBlueprintToMenuNoEffect("Pioneer Red Devil", No)
    controller:AddBlueprintToMenuNoEffect("Rover Minimal Jets", No)
  end
end

-- Add the default blueprints to the blueprint menu of all active controllers
function bpmenu.add_basic_blueprints_to_all_controllers()
  for i=scene:GetControllersCount()-1, 0, -1 do
    local controller = scene:GetController(i)
    if controller then 
      bpmenu.add_basic_blueprints(controller)
    end
  end
end

-- Activate a PS that shows to the player that a blueprint was added to the blueprint menu
function bpmenu.add_effect_for_added_blueprint(bp)
  local asm = scene:AddAssemblyPS("Blueprint Added Effect", VectorF(0,0))
  if asm then
    local ps = asm:GetPS(0)
    if ps then
      ps:SetPosition(bp:GetPosition())
      ps:SetTexture("..\\"..bp:GetFileName())
      ps:SetStartMoveVector(scene:RotateVectorForGravity(VectorF(0,30), bp:GetPosition()))
      ps:EmitBoom()
      ps:SetDeleteWhenEmpty(true)
      table.insert( bpmenu.bp_adding_eff, { ps:GetID(), bp:GetName(), bp:GetPosition(), bp:GetAssemblyID() } )
      --print_table(bpmenu.bp_adding_eff) -- !!! ??? this does some error inside print_table with tostring(VectorF)
    end
  end
end

-- Update the effects that plays when an blueprint is added
function bpmenu.update_added_blueprints_effects()
  -- check if there are some blueprints added, if so then add effect
  local adds = scene:GetBPsAddedToControllers()
  if adds then
    if adds:GetBPCount()>0 then
      for i = adds:GetBPCount()-1, 0, -1 do
        local bp = adds:GetBP(i)
        if bp then
          bpmenu.add_effect_for_added_blueprint(bp)
        end
      end
      adds:DeleteAll()
    end
  end
  
  -- update effects
  for i = table.getn(bpmenu.bp_adding_eff), 1, -1 do
    local ps = scene:GetPSByID(bpmenu.bp_adding_eff[i][1])
    if ps then 
      local to_asm = scene:GetAssemblyByID(bpmenu.bp_adding_eff[i][4])
      if to_asm then
        ps:SetGravityToPointPoint(to_asm:GetApproxPos())
      else
        table.remove(bpmenu.bp_adding_eff, i)
      end
    else
      table.remove(bpmenu.bp_adding_eff, i)
    end
  end
end
