
if not pid_controller then pid_controller = {} end
pid_controller.mt = {__index = pid_controller}

-- Create a proportional-integral-derivative controller. "inputs" is a table. Example: pid_controller:create{p=1, i=0.1, d=0.5, last_input=0, filter_leak=1, integral_max=10}
function pid_controller:create(inputs)
	return setmetatable(
		{
			p = inputs.p or 0,
			i = inputs.i or 0,
			d = inputs.d or 0,
			last_input = inputs.last_input or 0,
			filter_leak = inputs.filter_leak or 1,
			filtered_input = inputs.last_input or 0,
			integral = 0,
			integral_max = inputs.integral_max or math.huge / 2,
		},
		pid_controller.mt)
end

-- Returns a value that when used as input in e.g. a motor will decrease the difference between input and target
function pid_controller:update(raw_input, target_input)
	local target = target_input or 0
	self.filtered_input = self.filtered_input * (1-self.filter_leak) + raw_input * self.filter_leak
	local err = self.filtered_input - target
	local change = self.filtered_input - self.last_input
	self.last_input = self.filtered_input
	self.integral = math.min(math.max(self.integral + err, -self.integral_max), self.integral_max)
	return self.p*err + self.i*self.integral + self.d*change
end