--[[--
  Use this file to specify System preferences.
  Review [examples](+T:\!-Files-\!-Dropbox-\Dropbox\C2DTest\ZeroBraneStudio\cfg\user-sample.lua) or check [online documentation](http://studio.zerobrane.com/documentation.html) for details.
--]]--

-- dark theme (this part might be better to put in the file for User preferences)
local G = ...
styles = G.loadfile('cfg/tomorrow.lua')('TomorrowNightBright')
stylesoutshell = styles -- apply the same scheme to Output/Console windows
styles.auxwindow = styles.text -- apply text colors to auxiliary windows
styles.calltip = styles.text -- apply text colors to tooltips
styles.indicator.fncall = {fg = {204,147,147} } -- function calls just underlined
styles.indicator.varlocal = nil -- for local vars no special marker
styles.indicator.varglobal = nil -- global vars red underline
styles.linenumber.fg = {100,100,70}
styles.keywords0.b = false -- no bold keywords
styles.keywords2.b = false -- - " -

-- tabs and whitespace
editor.autotabs = true
editor.tabwidth = 2
editor.usetabs = false
editor.whitespace = false
editor.showfncall = true
editor.extraascent = nil

-- original settings
singleinstance = true
editor.autoactivate = true
editor.fold = false
editor.usewrap = false

-- load Crush2D api for all interpreters
api = {'crush2d'}