if not asteroid_belt then asteroid_belt = {} end
asteroid_belt.planetoids = {}

--belt = table of planetoid names/ids
function asteroid_belt.create(belt, center, arms, rotationFactor, xArmOffsetMax, yArmOffsetMax)
  belt = belt or {}
  center = center or VectorF(500, 500)  
  arms = arms or 2
	rotationFactor = rotationFactor or 0.005
  xArmOffsetMax = xArmOffsetMax or 2
  yArmOffsetMax = yArmOffsetMax or 3
  
  for i=1, 100 do table.insert(belt, "Planetoid"..i) end
	
  local armDist = math.twopi/arms
	local centerDist = 0
  
	for i, planetoidName in ipairs(belt) do
		local prevToidRadius = 4
		local thisToidRadius = 4
    centerDist = centerDist + prevToidRadius + thisToidRadius + scene:GetRandomF(0, yArmOffsetMax)
    local offset = scene:GetRandomF(-xArmOffsetMax/2, xArmOffsetMax/2) --/ centerDist --get smaller with longer arms
    if offset < 0 then 
			offset = -math.pow(offset, 2)
		else
			offset = math.pow(offset, 2)
		end 
    local rotation = centerDist * rotationFactor
    local ang = math.floor(scene:GetRandomF(0, math.twopi) / armDist) * armDist + offset + rotation
    local pos = VectorF(centerDist, 0):GetRotatedLeft(ang) + center
    
		if true then -- planetoidName is in folders 
      -- add planetoid TO
      table.insert(asteroid_belt.planetoids, {pos = pos, name = planetoidName}) --test
      scene:AddPS("Tip Bubble 1", pos)
    else
      --add blackhole PS
      scene:AddPS("Cloud", pos)
    end
  end
end


function asteroid_belt.update(ctrl, planetoids)
  for i, planetoid in ipairs(planetoids) do
    planetoidPos = planetoid.pos
    planetoid = planetoid.name
    local zone_name = planetoid
    local scene_name = planetoid
    local label = planetoid
    
    if not planetoidPos then return end
    scene:WriteToScreenByWorldPos(label, planetoidPos, VectorF(0,0), Yes, ColorRGBA(255,255,255,255), ColorRGBA(0,0,0,255))
    --if scene:IsInsideZone(ctrl:AimPoint(), zone_name) then 
    if ctrl:AimPoint():GetLengthTo(planetoidPos) < 3 then 
      if ctrl:Btn_Tool1_Press() then 
        c2d:LoadGameScene(scene_name, Yes) 
        c2d:SwitchToGameScene()
			elseif not ctrl:Btn_Tool1() then 
	      scene:WriteToScreenByWorldPos(label, scene:GetZoneCenter(zone_name),
  	    VectorF(0,0), Yes, ColorRGBA(255,255,255,255), ColorRGBA(0,0,0,255))
      end
    end
  end
end